/********************************************************

	Video encoder implementation
	Copyright 2000 Eugene Kuznetsov (divx@euro.ru)

*********************************************************/

#include "wine/windef.h"
#include "image.h"
#include "fourcc.h"
//#define TIMING
#include "except.h"
//#undef TIMING
#ifdef TIMING
#include "cpuinfo.h"
#endif

// windows headers causes gcc3.0 compilation problem
#include "VideoEncoder.h"
#include "VideoCodec.h"
#include "registry.h"

#if 0
struct ICINFO
{
	long	dwSize;		/* 00: */
	long	fccType;	/* 04:compressor type     'vidc' 'audc' */
	long	fccHandler;	/* 08:compressor sub-type 'rle ' 'jpeg' 'pcm '*/
	long	dwFlags;	/* 0c:flags LOshort is type specific */
	long	dwVersion;	/* 10:version of the driver */
	long	dwVersionICM;	/* 14:version of the ICM used */
	/*
	 * under Win32, the driver always returns UNICODE strings.
	 */
	short	szName[16];		/* 18:short name */
	short	szDescription[128];	/* 38:long name */
	short	szDriver[128];		/* 138:driver that contains compressor*/
					/* 238: */
};
#endif

#include <time.h>
#include <stdlib.h>
#include <cstdio>
#include <cstring>
#include <cctype>

#define __MODULE__ "VideoEncoder"

//using namespace std;

VideoEncoder::VideoEncoder(const CodecInfo& info, fourcc_t compressor, const BITMAPINFOHEADER& format)
    :IVideoEncoder(info), codec(0), m_iState(0), m_bh(0), m_obh(0), m_prev(0),
    m_iConfigDataSize(0), m_pConfigData(0)
{
    try
    {
	unsigned bihs = (format.biSize < (int) sizeof(BITMAPINFO)) ?
	    sizeof(BITMAPINFO) : format.biSize;
	m_bh = (BitmapInfo*) new char[bihs];
	memcpy(m_bh, &format, bihs);

	switch (compressor)
	{
	case fccMP41:
	case fccMP43:
	    compressor = fccDIV3;
	    break;
	case fccHFYU:
	    m_bh->biHeight = labs(m_bh->biHeight);
            break;
	}
	codec = control.Create(compressor, info, Module::Compress);

	m_comp_id = compressor;
	int r = codec->GetFormatSize(m_bh);
	if (r < 0)
	    throw FATAL("Can't handle this format");
	//printf("Format size %d\n", r);
	m_obh = (BITMAPINFOHEADER*) new char[r];
	memset(m_obh, 0, r);
	m_obh->biSize = r;
	r = codec->GetFormat(m_bh, m_obh);
	m_obh->biHeight = labs(m_obh->biHeight);
	m_obh->biBitCount = m_bh->biBitCount;
	if (r != 0)
	    throw FATAL("Can't handle this format");

	//m_obh->biHeight*=-1;
	codec->GetDefaultQuality(&m_iQual);
	m_iState = 1;
	if (codec->GetDefaultKeyFrameRate(&m_iKfFreq) != 0)
 	    m_iKfFreq = 0xFFFF;
	if (m_bh->biSizeImage == 0)
	    m_bh->biSizeImage = labs(m_bh->biWidth*m_bh->biHeight*((m_bh->biBitCount+7)/8));
	// Make sure that we can work with this format!
	ICINFO ici;
	codec->GetInfo(&ici);
#if 0
	printf("ICINFO  dwSize:%d  fccType:%.4s  fccHandler:%.4s\n"
	       "  dwFlags:0x%x  version:%d versionICM:%d\n"
	       "  name:%s  descrition:%s  driver:%s\n",
	       ici.dwSize, (char*)&ici.fccType, (char*)&ici.fccHandler,
	       ici.dwFlags, ici.dwVersion, ici.dwVersionICM,
	       ici.szName, ici.szDescription, ici.szDriver);
#endif
	if (ici.dwFlags & VIDCF_TEMPORAL) {
	    if (!(ici.dwFlags & VIDCF_FASTTEMPORALC)) {
		// Allocate backbuffer
		//throw FATAL("BACKBUFFER needed - implement me!!");
		//if (!(pPrevBuffer = new char[pbiInput->bmiHeader.biSizeImage]))
		//    throw MyMemoryError();
	    }
	}

        printf("Default Quality %d\n", m_iQual);
	ICCOMPRESSFRAMES icf;
	memset(&icf, 0, sizeof(icf));
	icf.dwFlags	= (long)&icf.lKeyRate;
        icf.lStartFrame = 0;
	icf.lFrameCount = 9999;
        icf.lQuality	= m_iQual;
	// is it just me or quality setting is broken for indeo 5?
	icf.lDataRate	= 910000;
	icf.lKeyRate	= (m_iKfFreq>=0)?m_iKfFreq:0;
	icf.dwRate	= 1000000;
        icf.dwScale	= 40000;

	codec->CompressFramesInfo(&icf);
	r = codec->CompressBegin(m_bh, m_obh);
	if (r != 0)
	    throw FATAL("CompressBegin failed ( probably unsupported input format )");
	codec->CompressEnd();

	// Save configuration state.
	//
	// Ordinarily, we wouldn't do this, but there seems to be a bug in
	// the Microsoft MPEG-4 compressor that causes it to reset its
	// configuration data after a compression session.  This occurs
	// in all versions from V1 through V3.
	//
	// Stupid fscking Matrox driver returns -1!!!

	m_iConfigDataSize = codec->GetStateSize();

	if (m_iConfigDataSize > 0)
	{
	    m_pConfigData = new char[m_iConfigDataSize];

	    m_iConfigDataSize = codec->GetState(m_pConfigData, m_iConfigDataSize);

	    // As odd as this may seem, if this isn't done, then the Indeo5
	    // compressor won't allow data rate control until the next
	    // compression operation!

	    if (m_iConfigDataSize)
		codec->SetState(m_pConfigData, m_iConfigDataSize);
	}
    }
    catch (...)
    {
	delete codec;
	delete[] (char*)m_bh;
	delete[] (char*)m_obh;
	delete[] m_prev;
	delete[] m_pConfigData;
	throw;
    }
}

VideoEncoder::~VideoEncoder()
{
    if (m_iState != 1)
	Stop();

    delete codec;
    delete[] (char*)m_bh;
    delete[] (char*)m_obh;
    delete[] m_prev;
    delete[] m_pConfigData;
}

int VideoEncoder::EncodeFrame(const CImage* src, void* dest, int* is_keyframe, uint_t* size, int* lpckid)
{
    //int st1, st2;
    static BITMAPINFOHEADER m_prevbh;
    if (m_iState != 2 || !src)
	return -1;
#ifdef TIMING
    st1=localcount();
#endif
    CImage* temp = 0;
    if (!src->IsFmt(m_bh))
	temp = new CImage(src, m_bh);
    //printf("Entering Compress()\n");
    int r = codec->Compress((m_iKfFreq ? ((m_iFrameNum%m_iKfFreq)? 0 : ICCOMPRESS_KEYFRAME) : 0),
			    m_obh, dest, m_bh,
			    temp ? temp->Data() : src->Data(),
			    (long*)lpckid, (long*)is_keyframe,
			    m_iFrameNum, 0,
			    m_iQual,
			    (is_keyframe) ? &m_prevbh : 0,
			    (is_keyframe) ? m_prev : 0);
    //printf("==> %d\n", result);
    if (temp)
	temp->Release();

    if (r == 0)
    {
	//if(m_prev==0)m_prev=new char[m_bh->biSizeImage];
	//memcpy(m_prev, src, m_bh->biSizeImage);
	if (!m_prev)
	    m_prev = new char[codec->CompressGetSize(m_bh, m_obh)];
	memcpy(m_prev, dest, m_obh->biSizeImage);
	m_prevbh = *m_bh;

#if 0
	// If we're using a compressor with a stupid algorithm (Microsoft Video 1),
	// we have to decompress the frame again to compress the next one....

	if (res==ICERR_OK && pPrevBuffer && (!lKeyRate || lKeyRateCounter>1)) {
	    res = ICDecompress(hic, dwFlags & AVIIF_KEYFRAME ? 0 : ICDECOMPRESS_NOTKEYFRAME
			       ,(LPBITMAPINFOHEADER)pbiOutput
			       ,pOutputBuffer
			       ,(LPBITMAPINFOHEADER)pbiInput
			       ,pPrevBuffer);
	}
#endif
    }
    m_iFrameNum++;
    *size = m_obh->biSizeImage;
    return r;
}

void VideoEncoder::Start()
{
    //cout << "STARTCOMPRESSION " << m_iState << endl;
    if (m_iState != 1)
	return;//wrong state
//    HRESULT hr=ICCompressBegin(hic, m_bh, m_obh);
    ICINFO ici;

    int r = codec->GetInfo(&ici);
    if (!r)
    {
        printf("Unable to retrieve video compressor info!");
    }

    ICCOMPRESSFRAMES icf;

    memset(&icf, 0, sizeof icf);
    //	ICM_COMPRESS_FRAMES_INFO:
    //
    //		dwFlags	      Trashed with address of lKeyRate in tests. Something
    //			      	might be looking for a non-zero value here, so better
    //			      	set it.
    //		lpbiOutput    NULL.
    //		lOutput	      0.
    //		lpbiInput     NULL.
    //		lInput	      0.
    //		lStartFrame   0.
    //		lFrameCount   Number of frames.
    //		lQuality      Set to quality factor, or zero if not supported.
    //		lDataRate     Set to data rate in 1024*kilobytes, or zero if not
    //			      	supported.
    //		lKeyRate      Set to the desired maximum keyframe interval.  For
    //			      	all keyframes, set to 1.

    icf.dwFlags		= (long)&icf.lKeyRate;
    icf.lStartFrame	= 0;
    icf.lFrameCount	= 99999;
    icf.lQuality	= m_iQual;
    icf.lDataRate	= 910000;
    icf.lKeyRate	= (m_iKfFreq>=0)?m_iKfFreq:0;
    icf.dwRate		= 1000000;
    icf.dwScale		= 40000;

    codec->CompressFramesInfo(&icf);

    r = codec->CompressBegin(m_bh, m_obh);
/*	printf("Starting compression \n");
	printf("  biSize %d\n", m_bh->biSize);
	printf("  biWidth %d\n", m_bh->biWidth);
	printf("  biHeight %d\n", m_bh->biHeight);
	printf("  biPlanes %d\n", m_bh->biPlanes);
	printf("  biBitCount %d\n", m_bh->biBitCount);
	printf("  biCompression %d='%.4s'\n", m_bh->biCompression, (char*) &m_bh->biCompression);
	printf("  biSizeImage %d\n", m_bh->biSizeImage);
	printf("Dest fmt:\n");
	printf("  biSize %d\n", m_obh->biSize);
	printf("  biWidth %d\n", m_obh->biWidth);
	printf("  biHeight %d\n", m_obh->biHeight);
	printf("  biPlanes %d\n", m_obh->biPlanes);
	printf("  biBitCount %d\n", m_obh->biBitCount);
	printf("  biCompression %d='%.4s'\n", m_obh->biCompression, (char*) &m_obh->biCompression);
	printf("  biSizeImage %d\n", m_obh->biSizeImage);
 */
    if (r != 0)
	printf("ICCompressBegin() failed ( shouldn't happen ), error code %d\n", (int)r);
    else
    {
	m_iFrameNum = 0;
	m_iState = 2;
    }
}

void VideoEncoder::Stop()
{
    //cout << "STOPCOMPRESSION " << m_iState << endl;
    if (m_iState == 2)
    {
	int r = codec->CompressEnd();
	if (r != 0)
	    printf("ICCompressEnd() failed ( shouldn't happen ), error code %d\n", (int)r);
	m_iState = 1;

	// Reset MPEG-4 compressor

	if (m_pConfigData && m_iConfigDataSize)
	    codec->SetState(m_pConfigData, m_iConfigDataSize);
    }
}

const BITMAPINFOHEADER& VideoEncoder::GetOutputFormat() const
{
    return *m_obh;
}

int VideoEncoder::GetOutputSize() const
{
    int lMaxPackedSize = codec->CompressGetSize(m_bh, m_obh);
    // Work around a bug in Huffyuv.  Ben tried to save some memory
    // and specified a "near-worst-case" bound in the codec instead
    // of the actual worst case bound.  Unfortunately, it's actually
    // not that hard to exceed the codec's estimate with noisy
    // captures -- the most common way is accidentally capturing
    // static from a non-existent channel.
    //
    // According to the 2.1.1 comments, Huffyuv uses worst-case
    // values of 24-bpp for YUY2/UYVY and 40-bpp for RGB, while the
    // actual worst case values are 43 and 51.  We'll compute the
    // 43/51 value, and use the higher of the two.

    if (record.fourcc == fccHFYU) {
	int lRealMaxPackedSize = m_obh->biWidth * m_obh->biHeight;

	if (m_bh->biCompression == 0)//BI_RGB
	    lRealMaxPackedSize = (lRealMaxPackedSize * 51) >> 3;
	else
	    lRealMaxPackedSize = (lRealMaxPackedSize * 43) >> 3;

	if (lRealMaxPackedSize > lMaxPackedSize)
	    lMaxPackedSize = lRealMaxPackedSize;

    }
    //printf("VideoEncoder::GetOutputSize() %d\n", lMaxPackedSize);
    return lMaxPackedSize;
}


int VideoEncoder::SetQuality(int quality)
{
    if (quality < 0 || quality >10000)
	return - 1;
    m_iQual = quality;
    return 0;
}

int VideoEncoder::SetKeyFrame(int freq)
{
    if (freq <= 0)
	codec->GetDefaultKeyFrameRate(&m_iKfFreq);
    else
	m_iKfFreq = freq;

    return 0;
}
