#ifndef AVIFILE_VIDEODECODER_H
#define AVIFILE_VIDEODECODER_H

/********************************************************

	Video decoder interface
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/
#include "videodecoder.h"
#include "Module.h"

/**
 * Win32 video decoder
 */
class VideoDecoder: public IVideoDecoder
{
public:
    VideoDecoder(const CodecInfo& info, const BITMAPINFOHEADER& format, int flip);
    ~VideoDecoder();
    virtual int SetDestFmt(int bits = 24, fourcc_t csp = 0);
    virtual CAPS GetCapabilities() const { return m_Caps; }
protected:
    virtual int DecodeInternal(const void* src, uint_t size, int is_keyframe, CImage* pImage);
    virtual void StartInternal();
    virtual void StopInternal();
    VideoCodec* m_pCodec;
    CAPS m_Caps;
    BitmapInfo m_bitrick;
    bool m_divx_trick;
    bool m_bUseEx;
private:
    void setDecoder(BitmapInfo& bi);
};

#endif //AVIFILE_VIDEODECODER_H
