/********************************************************

	Video decoder implementation
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/

#include "wine/windef.h"
#include "default.h"
#include "fourcc.h"
#include "cpuinfo.h"
#include "except.h"

#include "VideoDecoder.h"
#include "VideoEncoder.h"
#include "VideoCodec.h"
#include "DS_Filter.h"

#include <errno.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h> // labs
#include <stdio.h>

#define __MODULE__ "VideoDecoder"

#define ICDECOMPRESS_HURRYUP		0x80000000	/* don't draw just buffer (hurry up!) */
#define ICDECOMPRESS_UPDATE		0x40000000	/* don't draw just update screen */
#define ICDECOMPRESS_PREROL		0x20000000	/* this frame is before real start */
#define ICDECOMPRESS_NOTKEYFRAME	0x08000000	/* this frame is not a key frame */


//IVideoDecoder::IVideoDecoder
VideoDecoder::VideoDecoder(const CodecInfo& info, const BITMAPINFOHEADER& format, int flip)
    :IVideoDecoder(info, format), m_pCodec(0), m_divx_trick(false),
    m_bUseEx((info.kind == CodecInfo::Win32Ex))
{
    /* On2 Truemotion VP3.x support */
    try
    {
#warning NOT SURE
//
// MPEG-4 format has changed during development. Package
// binaries.zip includes mpg4c32.dll - old MPEG-4 codec
// with unlocked compression - and divxc32.dll,
// which differs from current MPEG-4 only by FOURCC's.
// The problem is to identify which is needed to us,
// because 'old' codec doesn't work with 'new' clips and
// vice versa. Unfortunately, they may simulate correct
// work until the moment of actual decompression. Then,
// you'll receive garbled picture and lots of warnings about
// hr=-100.
//

// I've got old video with fccHandler mp43 and biCompression MPG4.
// Dirk Vornheider sent me old video with both values MP42.
	//printf("BI %d  %.4s\n", m_bh->biBitCount, (char*)&m_bh->biBitCount);
	//if (m_bh->biBitCount > 0 && m_bh->biBitCount < 15)
	//    throw FATAL("Unsupported bit count: %d", m_bh->biBitCount);

	m_pCodec = control.Create(m_bh->biCompression, info, Module::Decompress);

	if (!m_pCodec)
	    throw FATAL("ICOpen failed");

	int h = m_pCodec->DecompressGetFormat(m_bh, 0);
	if (h <= 0)
	    throw FATAL("ICDecompressGetFormatSize failed");

	printf("VideoDecoder Size %d\n", h);
	char* t = new char[h];
	h = m_pCodec->DecompressGetFormat(m_bh, (BITMAPINFOHEADER*)t);
	memcpy((BITMAPINFOHEADER*)&m_obh, t, sizeof(BITMAPINFOHEADER));
        delete t;
        if (h != 0)
	{
	    printf("Declined format dump:\n");
            BitmapInfo(*m_bh).Print();
	    m_obh.Print();
	    printf(" Error %d\n", int(h));
	    throw FATAL("ICDecompressGetFormat failed");
	}

	setDecoder(m_obh);
	BitmapInfo mbi(m_obh);

	m_Caps = CAP_NONE;
	switch (info.fourcc_array[0])
	{
	case fccMP42:
	    m_divx_trick = true;
	case fccDIV3:
	case fccDIV4:
	case fccDIV5:
	case fccDIV6:
	    //case fccIV50: works normaly with YV12 (kabi)
            // IV50 doesn't support I420
	case fccMJPG: // YV12 works but incorrectly
	    // these codecs natively supports YUY2
	    m_Caps = (CAPS) (CAP_YUY2 | CAP_UYVY); //planar formats broken, others untested
	    //m_Caps = (CAPS)0xff;
	    break;
	case fccHFYU:
	    if (m_bh->biSize == 232)
                m_Caps = CAP_YUY2;
		break;
            // fall through for RGB mode
	default:
	    struct ct {
		fourcc_t fcc;
		CAPS cap;
	    } check[] = {
		{ fccIYUV, CAP_IYUV },
		{ fccUYVY, CAP_UYVY },
		{ fccYV12, CAP_YV12 },
		{ fccYVYU, CAP_YVYU },
		{ fccYUY2, CAP_YUY2 },
		//{ fccI420, CAP_I420 },
		{ 0, CAP_NONE }
	    };

	    for (ct* c = check; c->fcc; c++)
	    {
		mbi.SetSpace(c->fcc);
		/* On2 Truemotion VP3.x support */
		h = (m_bUseEx) ?
		    m_pCodec->DecompressQueryEx(m_bh, (BITMAPINFOHEADER*)&mbi):
		    m_pCodec->DecompressQuery(m_bh, (BITMAPINFOHEADER*)&mbi);

		if (h == 0)
		    m_Caps = (CAPS)(m_Caps | c->cap);
	    }
	}
	if (m_Caps)
	    printf("Decoder is capable of YUV output ( flags 0x%x)\n", (int)m_Caps);
    }
    catch (FatalError& error)
    {
        delete m_pCodec;
	throw;
    }
}

VideoDecoder::~VideoDecoder()
{
    Stop();
    delete m_pCodec;
}

void VideoDecoder::StartInternal()
{
#if 0
    printf("Starting decompression, format: \n");
    BitmapInfo(m_obh).Print();
    printf("Dest fmt:\n");
    BitmapInfo(m_decoder).Print();
#endif

    int tmpcomp = m_bitrick.biCompression;
    if (m_divx_trick)
	m_bitrick.biCompression = 0;
    /* On2 Truemotion VP3.x support */
    HRESULT hr = (m_bUseEx) ?
       m_pCodec->DecompressBeginEx(m_bh, (BITMAPINFOHEADER*)&m_bitrick) :
       m_pCodec->DecompressBegin(m_bh, (BITMAPINFOHEADER*)&m_bitrick);
    m_bitrick.biCompression = tmpcomp;
    //cout << "SZ " << hr << "  " << m_decoder.biSize << endl;
    //printf("DECODER COMPRESSSION  %.4s\n", (char*)&m_decoder.biCompression);
    if (hr != 0 && (hr != -2 || (m_bh->biCompression != fccMJPG
				 && m_bh->biCompression != fccmjpg)))
    {
	// FIXME  MJPG decoder (m3jpeg32.dll) returns -2
        // if anyone knows why - please fix it....
	BitmapInfo(*m_bh).Print();
	printf("Dest fmt:\n");
	BitmapInfo(m_decoder).Print();
	printf("WARNING: ICDecompressBegin() failed ( shouldn't happen ), hr=%d (%s)\n",
	       (int)hr, ((hr == ICERR_BADFORMAT) ? "Bad Format)" : "?)"));
    }
}

void VideoDecoder::StopInternal()
{
    int r = m_pCodec->DecompressEnd();
    if (r != 0)
	printf("WARNING: ICDecompressEnd() failed ( shouldn't happen ), hr=%d\n", r);
}

int VideoDecoder::DecodeInternal(const void* src, uint_t size, int is_keyframe, CImage* pImage)
{
    // BITMAPINFOHEADER o = *(BITMAPINFOHEADER*)(pImage->GetFmt());
    // if(o.biBitCount == 12)
    //     o.biBitCount = 16;

    //pImage->GetFmt()->Print();
    /* On2 Truemotion VP3.x support */
    int r = (m_bUseEx) ?
	m_pCodec->DecompressEx(((is_keyframe) ? 0 : ICDECOMPRESS_NOTKEYFRAME)
			       | ((pImage) ? 0 : ICDECOMPRESS_HURRYUP|ICDECOMPRESS_PREROL),
			       m_bh, src, &m_bitrick,
			       (pImage) ? pImage->Data() : 0) :
	m_pCodec->Decompress(((is_keyframe) ? 0 : ICDECOMPRESS_NOTKEYFRAME)
			     | ((pImage) ? 0 : ICDECOMPRESS_HURRYUP|ICDECOMPRESS_PREROL),
			     m_bh, src, &m_bitrick,
			     (pImage) ? pImage->Data() : 0);
    if (r && pImage)
	printf("VideoDecoder: warning: hr=%d\n", r);

    return r;
}

int VideoDecoder::SetDestFmt(int bits, fourcc_t csp)
{
    if (!CImage::Supported(csp, bits))
	return -1;

    //printf("SETDESTFMT %d   %.4s\n", bits, (char*)&csp);

    if (csp == 0)
    {
	switch (bits)
	{
	case 15:
	case 16:
	case 24:
	case 32:
	    // 16bit ??? if (record.fourcc_array[0] == fccMJPG)
	    //     m_obh.biSize=0x28;
	    m_obh.SetBits(bits);
	    switch (record.fourcc)
	    {
	    case fccASV1:
	    case fccASV2:
		// these codecs produces upside down RGB images
		break;
	    default:
		if (m_obh.biHeight > 0)
		    m_obh.biHeight *= -1;
	    }
	    break;
	default:
            return -1;
        }
    } else
	m_obh.SetSpace(csp);

    BitmapInfo tmpbi(m_decoder);
    setDecoder(m_obh);
    int tmp = m_obh.biHeight;
    //m_obh.biHeight = labs(m_obh.biHeight);
    m_obh.biHeight = labs(m_obh.biHeight);
    int tmpcomp = m_bitrick.biCompression;
    if (m_divx_trick)
	m_bitrick.biCompression = 0;
    /* On2 Truemotion VP3.x support */
    int r = (m_bUseEx) ?
       m_pCodec->DecompressQueryEx(m_bh, (BITMAPINFOHEADER*)&m_bitrick) :
       m_pCodec->DecompressQuery(m_bh, (BITMAPINFOHEADER*)&m_bitrick);
    m_obh.biHeight = tmp;
    m_bitrick.biCompression = tmpcomp;

    if (r != 0)
    {
	if (csp)
	    printf("WARNING: Unsupported color space 0x%x  (%.4s)\n",
		   csp, (char*)&csp);
	else
	    printf("WARNING; Unsupported bit depth: %d\n", bits);

        // set default 24bit
        tmpbi.SetBits(24);
	setDecoder(tmpbi);
    }

    //m_bh->biBitCount = bits; // don't remember what is this for
    Restart();

    return (r == 0) ? 0 : -1;
}

void VideoDecoder::setDecoder(BitmapInfo& bi)
{
    m_decoder = bi;
    m_bitrick = bi;
    switch (record.fourcc)
    {
    case fccHFYU:
        // huffyuv refuses to decode images if height is <0
	m_bitrick.biHeight = labs(m_bitrick.biHeight);
        break;
    }
}

/*
vim: tabstop=8
*/
