#ifndef VIDEOCODEC_H
#define VIDEOCODEC_H

#include "wine/windef.h"
#include "wine/winreg.h"
#include "wine/vfw.h"
#include "wine/driver.h"

#include "Module.h"

// using inlines for simple calls - safe useless stack copying

class VideoCodec
{
    Module* _module;
    int _handle;
public:
    VideoCodec(Module* module, int compressor, Module::Mode mode);
    ~VideoCodec();
    int GetFormat(BITMAPINFOHEADER* b1,BITMAPINFOHEADER* b2)
    {
	return _module->Message(_handle, ICM_COMPRESS_GET_FORMAT,
				(int)b1, (int)b2);
    }
    int GetFormatSize(BITMAPINFOHEADER* b)
    {
	return GetFormat(b, 0);
    }
    int GetDefaultKeyFrameRate(int* lpint)
    {
	return _module->Message(_handle, ICM_GETDEFAULTKEYFRAMERATE, (int)lpint, 0);
    }
    int GetDefaultQuality(int* lpint)
    {
	return _module->Message(_handle, ICM_GETDEFAULTQUALITY, (int)lpint, 0);
    }
    int CompressBegin(BITMAPINFOHEADER* lpbiInput, BITMAPINFOHEADER* lpbiOutput)
    {
	return _module->Message(_handle, ICM_COMPRESS_BEGIN,
				(int)lpbiInput, (int)lpbiOutput);
    }
    int CompressGetSize(BITMAPINFOHEADER* lpbiInput, BITMAPINFOHEADER* lpbiOutput)
    {
	return _module->Message(_handle, ICM_COMPRESS_GET_SIZE,
				(int)lpbiInput, (int)lpbiOutput);
    }
    int CompressQuery(BITMAPINFOHEADER* lpbiInput, BITMAPINFOHEADER* lpbiOutput)
    {
	return _module->Message(_handle, ICM_COMPRESS_QUERY,
				(int)lpbiInput, (int)lpbiOutput);
    }
    int CompressEnd()
    {
	return _module->Message(_handle, ICM_COMPRESS_END, 0, 0);
    }
    int Compress(long dwFlags,
		 LPBITMAPINFOHEADER lpbiOutput, void* lpData,
		 LPBITMAPINFOHEADER lpbiInput, const void* lpBits,
		 long* lpckid, long* lpdwFlags,
		 long lFrameNum,long dwFrameSize,long dwQuality,
		 LPBITMAPINFOHEADER lpbiPrev, void* lpPrev);
    int DecompressBegin(BITMAPINFOHEADER* lpbiInput, BITMAPINFOHEADER*  lpbiOutput)
    {
	return _module->Message(_handle, ICM_DECOMPRESS_BEGIN,
				(int)(lpbiInput), (int)(lpbiOutput));
    }

    /* On2 Truemotion VP3.x support */
    int DecompressBeginEx(BITMAPINFOHEADER* lpbiInput, BITMAPINFOHEADER*  lpbiOutput)
    {
	return _module->UniversalEx(_handle, ICM_DECOMPRESSEX_BEGIN,
				    (LPBITMAPINFOHEADER)lpbiInput,
				    (LPBITMAPINFOHEADER)lpbiOutput);
    }
    int DecompressQuery(BITMAPINFOHEADER* lpbiInput, BITMAPINFOHEADER* lpbiOutput)
    {
	return _module->Message(_handle, ICM_DECOMPRESS_QUERY,
				(int)lpbiInput, (int)lpbiOutput);
    }
    int DecompressQueryEx(BITMAPINFOHEADER* lpbiInput, BITMAPINFOHEADER* lpbiOutput)
    {
	return _module->UniversalEx(_handle, ICM_DECOMPRESSEX_QUERY,
				    (LPBITMAPINFOHEADER)lpbiInput,
				    (LPBITMAPINFOHEADER)lpbiOutput);
    }
    int DecompressGetFormat(BITMAPINFOHEADER* lpbiInput, BITMAPINFOHEADER* lpbiOutput)
    {
	return _module->Message(_handle, ICM_DECOMPRESS_GET_FORMAT,
				(int)lpbiInput, (int)lpbiOutput);
    }
    int DecompressEnd()
    {
	return _module->Message(_handle, ICM_DECOMPRESS_END, 0, 0);
    }
    int Decompress(long dwFlags, LPBITMAPINFOHEADER lpbiFormat,
		   const void* lpData, const LPBITMAPINFOHEADER lpbi,
		   void* lpBits);
    /* On2 Truemotion VP3.x support */
    int DecompressEx(long dwFlags, LPBITMAPINFOHEADER lpbiFormat,
		     const void* lpData, const LPBITMAPINFOHEADER lpbi,
		     void* lpBits);
    int CompressFramesInfo(ICCOMPRESSFRAMES* picf)
    {
	return _module->Message(_handle, ICM_COMPRESS_FRAMES_INFO, (int)picf, sizeof(*picf));
    }
    int GetInfo(ICINFO *pici)
    {
	return _module->Message(_handle, ICM_GETINFO, (int)pici, sizeof(*pici));
    }
    int GetState(void* config, long size)
    {
	return _module->Message(_handle, ICM_GETSTATE, (int)config, (int)size);
    }
    int GetStateSize()
    {
        return GetState(0, 0);
    }
    int SetState(void* config, long size)
    {
	return _module->Message(_handle, ICM_SETSTATE, (int)config, (int)size);
    }
    /* works only with divx.dll */
    int DivXSetPostprocessing(long quality)
    {
	// Win sources: #define DIVXSET_POSTPROCESSING (ICM_USER+80)
	return _module->Message(_handle, (ICM_USER + 80),
				(int)&quality, sizeof(quality));
    }
};

#endif // VIDEOCODEC_H
