#include "VideoCodec.h"
#include <stdlib.h>
//#include <stdio.h>

VideoCodec* VideoCodecControl::Create(int compressor, const CodecInfo& info, Module::Mode mode)
{
    //    cerr<<"VideoCodecControl::Create()"<<endl;
    //    cerr<<"_modules size: "<<_modules.size()<<endl;
    for (unsigned i = 0; i < _modules.size(); i++)
    {
	if (strcmp(_modules[i]->Name(), (const char*) info.dll) == 0)
	{
	    //fprintf(stderr, "create %s  %s\n", _modules[i]->Name(), info.dll.c_str());
	    return new VideoCodec(_modules[i], compressor, mode);
	}
    }
    Module* module = new Module((const char*)info.dll, *this);
    _modules.push_back(module);
    return new VideoCodec(module, compressor, mode);
}

VideoCodecControl::~VideoCodecControl()
{
    while (_modules.size() > 0)
    {
	Module* m = _modules.back();
        _modules.pop_back();
	m->ForgetParent();
	// at this time player using this codec has to be stopped
	// currently this is partial responsibility of user task
        // FIXME !!! - destroy codec thread if necessary
	//delete m;
    }
}

void VideoCodecControl::Erase(Module* mod)
{
    //cerr<<"Erasing module "<<(int)mod<<endl;
    for (unsigned i = 0; i < _modules.size(); i++)
	if (_modules[i] == mod)
	{
            // remove this member (swap with last one)
	    Module* m = _modules.back();
	    _modules.pop_back();
	    if (_modules.size() > i)
		_modules[i] = m;
	    //cerr<<"Success: new _modules size "<<_modules.size()<<endl;
	    break;
	}
}

VideoCodec::VideoCodec(Module* module, int compressor, Module::Mode mode)
    :_module(module)
{
    _handle = _module->CreateHandle(compressor, mode);
}

VideoCodec::~VideoCodec()
{
    //    cerr<<"Deleting codec"<<endl;
    _module->CloseHandle(_handle);
}

//
//
//  Here goes VFW API
//
//
int VideoCodec::Compress(long dwFlags,
			 LPBITMAPINFOHEADER lpbiOutput, void* lpData,
			 LPBITMAPINFOHEADER lpbiInput, const void* lpBits,
			 long* lpckid, long* lpdwFlags,long lFrameNum,
			 long dwFrameSize, long dwQuality,
			 LPBITMAPINFOHEADER lpbiPrev, void* lpPrev)
{
//    dwFlags		Equal to ICCOMPRESS_KEYFRAME if a keyframe is
//    			required, and zero otherwise.
//    lpckid		Always points to zero.
//    lpdwFlags		Points to AVIIF_KEYFRAME if a keyframe is required,
//    			and zero otherwise.
//    lFrameNum		Ascending from zero.
//    dwFrameSize	Always set to 7FFFFFFF (Win9x) or 00FFFFFF (WinNT)
//    			for first frame.  Set to zero for subsequent frames
//    			if data rate control is not active or not supported,
//    			and to the desired frame size in bytes if it is.
//    dwQuality		Set to quality factor from 0-10000 if quality is
//    			supported.  Otherwise, it is zero.
//    lpbiPrev		Set to NULL if not required.
//    lpPrev		Set to NULL if not required.
    ICCOMPRESS	iccmp;
    iccmp.dwFlags	= dwFlags;
    iccmp.lpbiOutput	= lpbiOutput;
    iccmp.lpOutput	= lpData;
    iccmp.lpbiInput	= lpbiInput;
    (const void*) iccmp.lpInput	= lpBits;

    iccmp.lpckid	= lpckid;
    iccmp.lpdwFlags	= lpdwFlags;
    iccmp.lFrameNum	= lFrameNum;
    iccmp.dwFrameSize	= dwFrameSize;
    iccmp.dwQuality	= dwQuality;
    iccmp.lpbiPrev	= lpbiPrev;
    iccmp.lpPrev	= lpPrev;
    return _module->Message(_handle,ICM_COMPRESS, (int)&iccmp, sizeof(iccmp));
}

int VideoCodec::Decompress(long dwFlags, LPBITMAPINFOHEADER lpbiFormat,
			   const void* lpData, LPBITMAPINFOHEADER lpbi,
			   void* lpBits)
{
    ICDECOMPRESS	icd;
    icd.dwFlags		= dwFlags;
    icd.lpbiInput	= lpbiFormat;
    (const void*) icd.lpInput = lpData;

    icd.lpbiOutput	= lpbi;
    icd.lpOutput	= lpBits;
    icd.ckid		= 0;
    return _module->Message(_handle, ICM_DECOMPRESS, (int)&icd, sizeof(icd));
}

/* On2 Truemotion VP3.x support */
int VideoCodec::DecompressEx(long dwFlags, LPBITMAPINFOHEADER lpbiFormat,
			     const void* lpData, LPBITMAPINFOHEADER lpbi,
			     void* lpBits)
{
    ICDECOMPRESSEX icd;

    icd.dwFlags = dwFlags;

    icd.lpbiSrc = lpbiFormat;
    (const void*) icd.lpSrc = lpData;

    icd.lpbiDst = lpbi;
    icd.lpDst = lpBits;

    icd.xSrc = icd.ySrc = 0;
    icd.dxSrc = lpbiFormat->biWidth;
    icd.dySrc = labs(lpbiFormat->biHeight);

    icd.xDst = icd.yDst = 0;
    icd.dxDst = lpbi->biWidth;
    icd.dyDst = labs(lpbi->biHeight);

    //icd.ckid = 0;
    return _module->Message(_handle, ICM_DECOMPRESSEX, (int)&icd, sizeof(icd));
}
