#include "wine/winreg.h"
#include "wine/vfw.h"
#include "wine/driver.h"
#include "registry.h"
#include "ldt_keeper.h"
#include "driver.h"

#ifndef NOAVIFILE_HEADERS
#include "default.h"
#else
#include "libwin32.h"
#endif
#include "Module.h"

#include <stdio.h>
#include <stdlib.h> // labs
#include <string.h>

#define __MODULE__ "Win32 loader"

VideoCodecControl control;

Module::Module(const char* name, VideoCodecControl& parent) throw(FatalError)
    :_parent(parent), forgotten(0), _refcount(0), m_pName(name)
{
    if (name == 0)
	throw FATAL("Win32 dll library is NULL!");

    m_pHandle = LoadLibraryA(name);
    if (!m_pHandle)
	throw FATAL("Could not load Win32 dll library: %s", name);

    try
    {
	const char* keyname = 0;
	if (!strcmp(name, "divxc32.dll"))
	    keyname = "Software\\LinuxLoader\\div3";
	else if (!strcmp(name, "divxc32f.dll"))
	    keyname = "Software\\LinuxLoader\\div4";
	else if (!strcmp(name, "divxcvki.dll"))
	    keyname = "Software\\LinuxLoader\\div5";
	else if (!strcmp(name, "divxcfvk.dll"))
	    keyname = "Software\\LinuxLoader\\div6";

	if (keyname)
	{
	    int newkey;
	    int bitrate;
	    int count = 4;

	    if(RegOpenKeyExA(HKEY_CURRENT_USER, keyname, 0, 0, &newkey)!=0)
	    {
		printf("Could not open key %s\n", keyname);
		//		cerr<<"Could not open Divx key"<<endl;
		goto no_reg;
	    }
	    //printf("sethandle %s\n", keyname);
	    if(RegQueryValueExA(newkey, "BitRate", 0, 0, &bitrate, &count)==0)
	    {
		printf("BitRate %d\n", bitrate);
		*(double*)((char*)m_pHandle+0x14c0)=bitrate;
	    }
	    else 
		printf("No 'BitRate' value present\n");
	    if(RegQueryValueExA(newkey, "KeyFrames", 0, 0, &bitrate, &count)==0)
	    {
		printf("KeyFrames %d\n", bitrate);
		*(long*)((char*)m_pHandle+0x28af)=bitrate;
	    }
	    if(RegQueryValueExA(newkey, "Crispness", 0, 0, &bitrate, &count)==0)
	    {
		printf("Crispness %d\n", bitrate);
		*(long*)((char*)m_pHandle+0x28a8)=bitrate;
	    }
	no_reg:
	    RegCloseKey(newkey);
	}

	DriverProc=(DRIVER_PROC) GetProcAddress(m_pHandle, "DriverProc");
	if (!DriverProc)
	    throw FATAL("Not a valid Win32 dll library: %s", name);

	driver.uDriverSignature = 0;
	driver.hDriverModule = m_pHandle;
	driver.DriverProc = (DRIVERPROC)DriverProc;
	driver.dwDriverID = 0;

	Setup_FS_Segment();

	STORE_ALL;
	DriverProc(0, (int)&driver, DRV_LOAD, 0, 0);
	REST_ALL;

	STORE_ALL;
	DriverProc(0, (int)&driver, DRV_ENABLE, 0, 0);
	REST_ALL;

	printf("Using Win32 dll library: %s\n", name);
        CodecAlloc();
    }
    catch (FatalError& e)
    {
	FreeLibrary(m_pHandle);
	throw;
    }
}

Module::~Module()
{
    Setup_FS_Segment();

    STORE_ALL;
    DriverProc(0, (int)&driver, DRV_FREE, 0, 0);
    //printf("decrefoucount %d\n", _refcount);
    REST_ALL;

    FreeLibrary(m_pHandle);
    if (!forgotten)
	_parent.Erase(this);
    CodecRelease();
}

int Module::CreateHandle(int compressor, Mode mode)
{
    ICOPEN icopen;
    icopen.fccType    = mmioFOURCC('v', 'i', 'd', 'c');
    icopen.fccHandler = compressor;
    icopen.dwSize     = sizeof(ICOPEN);
    icopen.dwFlags    = (mode == Compress) ? ICMODE_COMPRESS : ICMODE_DECOMPRESS;

    driver.dwDriverID = ++_refcount;
    DRVR* hDriver = new DRVR(driver);
    // cerr<<"Creating new handle for _refcount "<<_refcount<<", driver "<<(int)hDriver<<endl;
    // cerr.setf(ios::hex, ios::basefield);
    // cerr<<"fcc: "<<icopen.fccType<<", handler: "<<icopen.fccHandler<<endl;
    // cerr.setf(ios::dec, ios::basefield);

    Setup_FS_Segment();

    STORE_ALL;
    hDriver->dwDriverID=DriverProc((int)_refcount, (int)hDriver, DRV_OPEN,
				   0, (int) &icopen);
    REST_ALL;
    // cerr<<"New ID "<<hDriver->dwDriverID<<endl;
    if (!hDriver->dwDriverID)
	throw FATAL("Module::CreateHandle: DRV_OPEN failed");

    return (int) hDriver;
}

int Module::CloseHandle(int handle)
{
    Setup_FS_Segment();

    DRVR* hDriver = (DRVR*) handle;
    //printf("CLOSE HANDLE %s\n", Name());
    DriverProc(hDriver->dwDriverID, (int)hDriver, DRV_CLOSE, 0, 0);
    //printf("decrefoucount %d\n", _refcount);
    _refcount--;
    //if (_refcount==0)
    //    delete this;
    delete hDriver;

    return 0;
}

/* On2 Truemotion VP3.x support */
int Module::UniversalEx(int handle, int command,
			LPBITMAPINFOHEADER lpbi_format,
			LPBITMAPINFOHEADER lpbi)
{
    ICDECOMPRESSEX icd;

    icd.dwFlags = 0;

    icd.lpbiSrc = lpbi_format;
    icd.lpSrc = 0;

    icd.lpbiDst = lpbi;
    icd.lpDst = 0;

    icd.xSrc = icd.ySrc = 0;
    icd.dxSrc = lpbi_format->biWidth;
    icd.dySrc = labs(lpbi_format->biHeight);

    icd.xDst = icd.yDst = 0;
    icd.dxDst = lpbi->biWidth;
    icd.dyDst = labs(lpbi->biHeight);
        
    //icd.ckid = 0;
    STORE_ALL;
    int result = Message(handle, command, (long)&icd, sizeof(icd));
    REST_ALL;
    return result;
}

//FIXME - handle should be void*
int Module::Message(int handle, int message, int arg1, int arg2)
{
    DRVR* module= (DRVR*) handle;
    char qw[300];

    Setup_FS_Segment();

#ifndef __svr4__
    __asm__ __volatile__ ("fsave (%0)\n\t": :"r"(&qw));
#endif

    STORE_ALL;
    int result = DriverProc(module->dwDriverID, handle, message, arg1, arg2);
    REST_ALL;

#ifndef __svr4__
    __asm__ __volatile__ ("frstor (%0)\n\t": :"r"(&qw));
#endif

    return result;
}
