#ifndef AVIFILE_DS_VIDEODECODER_H
#define AVIFILE_DS_VIDEODECODER_H

#ifndef NOAVIFILE_HEADERS
#include "videodecoder.h"
#else
#include "libwin32.h"
#endif
#include "DS_Filter.h"

class DS_VideoDecoder: public IVideoDecoder, public IRtConfig
{
public:
    DS_VideoDecoder(const CodecInfo& info, const BITMAPINFOHEADER& format, int flip, int maxauto);
    ~DS_VideoDecoder();
    virtual CAPS GetCapabilities() const {return m_Caps;}
    int SetDestFmt(int bits = 24, fourcc_t csp = 0);
    int SetDirection(int d);
    // IRtConfig interface
    virtual HRESULT GetValue(const char*, int&);
    virtual HRESULT SetValue(const char*, int);
#ifndef NOAVIFILE_HEADERS
protected:
#endif
    int DecodeInternal(const void* src, uint_t size, int is_keyframe, CImage* pImage);
    void StartInternal();
    void StopInternal();
    DS_Filter* m_pDS_Filter;
    AM_MEDIA_TYPE m_sOurType, m_sDestType;
    VIDEOINFOHEADER* m_sVhdr;
    VIDEOINFOHEADER* m_sVhdr2;
    CAPS m_Caps;                // capabilities of DirectShow decoder
    int m_iLastQuality;         // remember last quality as integer
    int m_iMinBuffers;
    int m_iMaxAuto;
    bool m_bIsDivX;             // for speed
    bool m_bIsDivX4;            // for speed
};

#endif /* AVIFILE_DS_VIDEODECODER_H */
