#ifndef LIBWIN32_FILLPLUGINS_H
#define LIBWIN32_FILLPLUGINS_H

#include "infotypes.h"
#include "fourcc.h"

static const char none_about[] =
    "No help available for this codec.";

static void add_divx(avm::vector<CodecInfo>& ci)
{
    static const char divx_about[] =
	"Very popular MPEG-4 video codec, based on "
	"Microsoft MPEG-4 implementation. Advanced "
	"compression technologies allow it to "
	"compress 640x480x25 video with a perfect "
	"quality into 100-150 kbytes/s ( 3-4 times "
	"less than MPEG-2 ), by the cost of increased "
	"requirements for playback.<br>"
	"See <a href=\"http://www.divx.com\">http://www.divx.com</a> and "
	"<a href=\"http://www.mydivx.com\">http://www.mydivx.com</a>";
    static const GUID wmv1_clsid =
    {
	0x4facbba1, 0xffd8, 0x4cd7,
	{0x82, 0x28, 0x61, 0xe2, 0xf6, 0x5c, 0xb1, 0xae}
    };
    static const GUID wmv2_clsid =
    {
	0x521fb373, 0x7654, 0x49f2,
	{0xbd, 0xb1, 0x0c, 0x6e, 0x66, 0x60, 0x71, 0x4f}
    };
#ifndef GUIDS_H
    static const GUID CLSID_DivxDecompressorCF =
    {
	0x82CCd3E0, 0xF71A, 0x11D0,
	{ 0x9f, 0xe5, 0x00, 0x60, 0x97, 0x78, 0xaa, 0xaa}
    };
#endif
    static const fourcc_t wmv1_codecs[] = { fccWMV1, fccwmv1, 0 };
    /* it may be able to decode wmv1, but it's not */
    static const fourcc_t wmv2_codecs[] = { fccWMV2, fccwmv2, 0 };
    /* divx is able to decode large variety of formats */
    static const fourcc_t div3_codecsd[] = { fccDIV3, fccdiv3, fccDIV4, fccdiv4,
    				       fccDIV5, fccdiv5, fccDIV6, fccdiv6,
                                       fccMP41, fccMP43, fccmp43,
    				       fccAP41, fccap41, fccAP42, fccap42,
				       0 };
    static const fourcc_t div3_codecs[] = { fccDIV3, fccdiv3, 0 };
    static const fourcc_t div4_codecs[] = { fccDIV4, fccdiv4, 0 };
    // using different codec - divxcfvk.ax when available
    static const fourcc_t div5_codecs[] = { fccDIV5, fccdiv5, 0 };
    static const fourcc_t div56_codecs[] = { fccDIV5, fccdiv5, fccDIV6, fccdiv6, 0 };
    static const fourcc_t div6_codecs[] = { fccDIV6, fccdiv6, 0 };

// FIFO order is important - if this will ever change - few things
// would have to be repaired

    avm::vector<AttributeInfo> vs;
    avm::vector<AttributeInfo> vs_empty; 
    avm::vector<AttributeInfo> ds;
    vs.push_back("BitRate");
    vs.push_back("Crispness");
    vs.push_back("KeyFrames");
    ds.push_back(AttributeInfo("Quality", "Quality/CPU balance ( 0 fastest )", AttributeInfo::Integer, 0, 4));

    avm::vector<AttributeInfo> ds1;
    ds1.push_back(AttributeInfo("Quality", "Quality/CPU balance ( 0 fastest )", AttributeInfo::Integer, 0, 4));
    ds1.push_back(AttributeInfo("MaxAuto", "Maximum autoquality level",
				AttributeInfo::Integer, 0, 4));
    ds1.push_back(AttributeInfo("Saturation", "Saturation", AttributeInfo::Integer, 0, 100));
    ds1.push_back(AttributeInfo("Brightness", "Brightness", AttributeInfo::Integer, 0, 100));
    ds1.push_back(AttributeInfo("Hue", "Hue", AttributeInfo::Integer, 0, 100));
    ds1.push_back(AttributeInfo("Contrast", "Contrast", AttributeInfo::Integer, 0, 100));

    // DS player
    ci.push_back(CodecInfo(div56_codecs, "DivX ;-) VKI DirectShow", "divxcvki.ax",
			   divx_about, CodecInfo::DShow_Dec, "divxvkil",
			   CodecInfo::Video, CodecInfo::Decode,
			   &CLSID_DivxDecompressorCF, vs_empty, ds1));
    // DS player
    ci.push_back(CodecInfo(div3_codecsd, "DivX ;-) DirectShow", "divx_c32.ax",
			   divx_about, CodecInfo::DShow_Dec, "divxvki_dshow",
			   CodecInfo::Video, CodecInfo::Decode,
			   &CLSID_DivxDecompressorCF, vs_empty, ds1));
    // for encoding
    ci.push_back(CodecInfo(div6_codecs, "DivX ;-) VKI (Fast-Motion)", "divxcfvk.dll",
			   divx_about, CodecInfo::Win32, "divxvkif_enc",
			   CodecInfo::Video, CodecInfo::Both, 0, vs_empty, ds));
    // for encoding
    ci.push_back(CodecInfo(div5_codecs,	"DivX ;-) VKI (Low-Motion)", "divxcvki.dll",
			   divx_about, CodecInfo::Win32, "divxvkil_enc",
			   CodecInfo::Video, CodecInfo::Both, 0, vs_empty, ds));
    // for encoding
    ci.push_back(CodecInfo(div4_codecs, "DivX ;-) Fast-Motion", "divxc32f.dll",
			   divx_about, CodecInfo::Win32, "divxf",
			   CodecInfo::Video, CodecInfo::Both, 0, vs, ds));
    // for encoding
    ci.push_back(CodecInfo(div3_codecs,	"DivX ;-) Low-Motion", "divxc32.dll",
			   divx_about, CodecInfo::Win32, "divx",
			   CodecInfo::Video, CodecInfo::Both, 0, vs, ds));

    ci.push_back(CodecInfo(wmv1_codecs, "Windows Media Video 7 DirectShow",
			   "wmvds32.ax",
			   none_about, CodecInfo::DShow_Dec, "wmv7",
			   CodecInfo::Video, CodecInfo::Decode,
			   &wmv1_clsid, vs_empty, ds1));

    ci.push_back(CodecInfo(wmv2_codecs, "Windows Media Video 8 DirectShow",
			   "wmv8ds32.ax",
			   none_about, CodecInfo::DShow_Dec, "wmv8",
			   CodecInfo::Video, CodecInfo::Decode,
			   &wmv2_clsid, vs_empty, ds1));

#if 1
    // doesn't work at all (?) - Not a valid Win32 dll library
    ci.push_back(CodecInfo(wmv1_codecs,	"WMV dec dll ",
			   "wmvdmod.dll",
			   none_about, CodecInfo::Win32, "wmvdmod",
			   CodecInfo::Video, CodecInfo::Decode));
    ci.push_back(CodecInfo(wmv1_codecs,	"WMV enc dll ",
			   "wmvdmoe.dll",
			   none_about, CodecInfo::Win32, "wmvdmo_enc",
			   CodecInfo::Video, CodecInfo::Encode));

    ci.push_back(CodecInfo(wmv2_codecs,	"WMV8 dec dll ",
			   "wmv8dmod.dll",
			   none_about, CodecInfo::Win32, "wmv8dmod",
			   CodecInfo::Video, CodecInfo::Decode));
#endif
}

static void add_angel(avm::vector<CodecInfo>& ci)
{
    // crashing - using divx instead of this
    const fourcc_t apxx_codecs[] = { fccAP41, fccap41, fccAP42, fccap42, 0 };

    ci.push_back(CodecInfo(apxx_codecs, "AngelPotion MPEG-4", "apmpg4v1.dll",
			   none_about, CodecInfo::Win32, "angelpotion"));
}

static void add_ati(avm::vector<CodecInfo>& ci)
{
    const fourcc_t vcr1_codecs[] = { fccVCR1, 0 };
    const fourcc_t vcr2_codecs[] = { fccVCR2, 0 };

    ci.push_back(CodecInfo(vcr1_codecs, "ATI VCR-1", "ativcr1.dll",
			   none_about, CodecInfo::Win32, "vcr1",
			   CodecInfo::Video, CodecInfo::Decode));

    ci.push_back(CodecInfo(vcr2_codecs, "ATI VCR-2", "ativcr2.dll",
			   none_about, CodecInfo::Win32, "vcr2",
			   CodecInfo::Video, CodecInfo::Decode));
}

static void add_asus(avm::vector<CodecInfo>& ci)
{
    const fourcc_t asv1_codecs[] = { fccASV1, 0 };
    const fourcc_t asv2_codecs[] = { fccASV2, 0 };

    ci.push_back(CodecInfo(asv1_codecs, "ASUS V1 - crash", "asusasvd.dll",
			   none_about, CodecInfo::Win32, "asv1",
			   CodecInfo::Video, CodecInfo::Decode));

    ci.push_back(CodecInfo(asv2_codecs, "ASUS V2", "asusasv2.dll",
			   none_about, CodecInfo::Win32, "asv2",
                           CodecInfo::Video, CodecInfo::Decode));
}

static void add_brooktree(avm::vector<CodecInfo>& ci)
{
    static const char brook_about[] = "BtV Media Stream Version 1.0\n"
	"Copyright Brooktree Corporation 1994-1997\n";
    static const fourcc_t bt20_codecs[] = {
	mmioFOURCC('B', 'T', '2', '0'), 0 };
    static const fourcc_t yuv411_codecs[] = {
	mmioFOURCC('Y', '4', '1', 'P'), 0 };
    static const fourcc_t yvu9_codecs[] = {
	mmioFOURCC('Y', 'V', 'Y', '9'), 0 };

    // missing: Called unk_GetWindowDC

    ci.push_back(CodecInfo(bt20_codecs, "Brooktree\256 ProSummer Video (32)",
			   "btvvc32.drv",
			   brook_about, CodecInfo::Win32, "btree",
                           CodecInfo::Video, CodecInfo::Both));
    ci.push_back(CodecInfo(yuv411_codecs, "Brooktree\256 YUV411 Raw",
			   "btvvc32.drv",
			   brook_about, CodecInfo::Win32, "btree_yuv411",
                           CodecInfo::Video, CodecInfo::Both));

    ci.push_back(CodecInfo(yvu9_codecs, "Brooktree\256 YVU9 Raw",
			   "btvvc32.drv",
			   brook_about, CodecInfo::Win32, "btree_yvu9",
                           CodecInfo::Video, CodecInfo::Decode));

}

static void add_dvsd(avm::vector<CodecInfo>& ci)
{
    static const char dvsd_about[] = "Sony Digital Video (DV)";
    static const fourcc_t dvsd_codecs[] = {
	fccdvsd, fccDVSD, fccdvhd, fccdvsl, 0 };
    static const GUID dvsd_clsid =
    {
	0xB1B77C00, 0xC3E4, 0x11CF,
	{0xAF, 0x79, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42}
    };
    ci.push_back(CodecInfo(dvsd_codecs,	"DVSD",	"qdv.dll",
			   dvsd_about, CodecInfo::DShow_Dec, "qdv",
			   CodecInfo::Video, CodecInfo::Decode,
			   &dvsd_clsid));
    //  not a true Win32 library
    //ci.push_back(CodecInfo(dvsd_codecs,
    //    				"DVSD",	"qdv.dll",
    //    				dvsd_about, CodecInfo::Win32,
    //    				CodecInfo::Video, CodecInfo::Both));
}

static void add_divx4(avm::vector<CodecInfo>& ci)
{
    // External func COMCTL32.dll:17
#ifndef GUIDS_H
    static const GUID IID_IDivxFilterInterface =
    {
	0x78766964, 0x0000, 0x0010, 
	{0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71}
    };
#endif
    avm::vector<AttributeInfo> vs_empty;
    avm::vector<AttributeInfo> ds;
    ds.push_back(AttributeInfo("Postprocessing", "Postprocessing", AttributeInfo::Integer, 0, 6));
    ds.push_back(AttributeInfo("MaxAuto", "Maximum autoquality level",
			       AttributeInfo::Integer, 0, 6));
    ds.push_back(AttributeInfo("Saturation", "Saturation", AttributeInfo::Integer, -128, 127));
    ds.push_back(AttributeInfo("Brightness", "Brightness", AttributeInfo::Integer, -128, 127));
    ds.push_back(AttributeInfo("Contrast", "Contrast", AttributeInfo::Integer, -128, 127));
    avm::vector<AttributeInfo> ds1;
    ds1.push_back(AttributeInfo("Postprocessing", "Postprocessing", AttributeInfo::Integer, 0, 6));
    static const char opendivxw_about[] = "Win32 DivX 4.0 Beta Codec MPEG-4";
    static const fourcc_t opendivxw_codecs[] =
    {
	fccDIVX, fccdivx, fccDIV1, fccdiv1, fccMP4S, fccmp4s, 0x4, 0
    };
    static const fourcc_t div3_codecs[] =
    {
	// DIV3 - works but only for some movies
	fccDIVX, fccDIV3, fccdiv3, fccDIV4, fccdiv4,
	fccDIV5, fccdiv5, fccDIV6, fccdiv6,
	fccMP41, fccMP43, fccmp43,
	fccAP41, fccap41, fccAP42, fccap42, 0
    };
    static const fourcc_t divxall_codecs[] =
    {
	fccDIVX, fccdivx, fccDIV1, fccdiv1, fccMP4S, fccmp4s, 0x4,
	fccDIVX, fccDIV3, fccdiv3, fccDIV4, fccdiv4,
	fccDIV5, fccdiv5, fccDIV6, fccdiv6,
	fccMP41, fccMP43, fccmp43,
	fccAP41, fccap41, fccAP42, fccap42, 0
    };

    // implementation of some Direct Draw interface is not necessary
    // check fails but codec works
    ci.push_back(CodecInfo(divxall_codecs, "Win32 DivX4 4.0 DirectShow",
			   "divxdec.ax",
			   opendivxw_about, CodecInfo::DShow_Dec, "divx4ds",
			   CodecInfo::Video, CodecInfo::Decode,
			   0, vs_empty, ds));

    ci.push_back(CodecInfo(divxall_codecs, "Win32 DivX4 4.0 Beta Codec",
			   "divx.dll",
			   opendivxw_about, CodecInfo::Win32, "divx4vfw",
			   CodecInfo::Video,
			   // there is some bug while checking for support
                           // for YUY2 & YV12 support for encoder  FIXME
			   CodecInfo::Decode,
			   //CodecInfo::Both,
			   0, vs_empty, ds1));
}

static void add_indeo(avm::vector<CodecInfo>& ci)
{
    static const char ivxx_about[] =
	"A set of wavelet video codecs, developed "
	"by Intel and currently owned by Ligos corp. "
	"Indeo Video 5.0 with turned on \"QuickCompress\" "
	"option is a good choice for real-time video "
	"capture - it is faster than DivX ;-) and compresses "
	"data better than Motion JPEG.<br>"
	"Home page:<a href=\"http://www.ligos.com/indeo\"> http://www.ligos.com/indeo</a>";
#ifndef GUIDS_H
    static const GUID CLSID_IV50_Decoder =
    {
	0x30355649, 0x0000, 0x0010,
	{0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71}
    };
#endif
    static const fourcc_t iv50_codecs[] = { fccIV50, fcciv50, 0 };
    static const fourcc_t iv41_codecs[] = { fccIV41, fcciv41, 0 };
    static const fourcc_t iv32_codecs[] = { fccIV32, fcciv32, 0 };
    static const fourcc_t iv31_codecs[] = { fccIV31, fcciv31, 0 };
    static const fourcc_t iv3132_codecs[] = { fccIV31, fcciv31, fccIV32, fcciv32, 0 };
    avm::vector<AttributeInfo> vs;
    avm::vector<AttributeInfo> ds;

    ds.push_back(AttributeInfo("Saturation", "Saturation", AttributeInfo::Integer, -100, 100));
    ds.push_back(AttributeInfo("Brightness", "Brightness", AttributeInfo::Integer, -100, 100));
    ds.push_back(AttributeInfo("Contrast", "Contrast", AttributeInfo::Integer, -100, 100));
    ci.push_back(CodecInfo(iv50_codecs, "Indeo\256 Video 5.0 DirectShow", "ir50_32.dll",
			   ivxx_about, CodecInfo::DShow_Dec, "indeo5ds",
			   CodecInfo::Video, CodecInfo::Decode,
			   &CLSID_IV50_Decoder, vs, ds));
    vs.push_back("QuickCompress");
    ci.push_back(CodecInfo(iv50_codecs, "Indeo\256 Video 5.04", "ir50_32.dll",
			   ivxx_about, CodecInfo::Win32, "indeo5",
			   CodecInfo::Video, CodecInfo::Both, 0, vs));
    ci.push_back(CodecInfo(iv41_codecs,	"Indeo Video 4.1", "ir41_32.dll",
			   ivxx_about, CodecInfo::Win32, "indeo4",
			   CodecInfo::Video, CodecInfo::Both, 0, vs));
    ci.push_back(CodecInfo(iv3132_codecs, "Indeo Video 3.1/3.2 decoder", "ir32_32.dll",
			   ivxx_about, CodecInfo::Win32, "indeo3",
			   CodecInfo::Video, CodecInfo::Decode));
    ci.push_back(CodecInfo(iv32_codecs, "Indeo Video 3.2", "ir32_32.dll",
			   ivxx_about, CodecInfo::Win32, "indeo32_enc",
			   CodecInfo::Video, CodecInfo::Encode));
    ci.push_back(CodecInfo(iv31_codecs, "Indeo Video 3.1", "ir32_32.dll",
			   ivxx_about, CodecInfo::Win32, "indeo31_enc",
			   CodecInfo::Video, CodecInfo::Encode));
}

static void add_morgan(avm::vector<CodecInfo>& ci)
{
    static const char mjpg_about[] =
	"Very fast Motion JPEG video codec, by Morgan "
	"Multimedia company. Recommended for "
	"video capture on slow machines or in high "
	"resolutions. Shareware. Current version "
	"is time-limited and will stop working after "
	"Mar. 1, 2001. Registration costs $25. Visit "
	"their web site for details.<br>"
	"Web site: <a href=\"http://www.morgan-multimedia.com\">http://www.morgan-multimedia.com</a>";
    static const GUID CLSID_MorganMjpeg =
    {
	0x6988b440, 0x8352, 0x11d3,
	{0x9b, 0xda, 0xca, 0x86, 0x73, 0x7c, 0x71, 0x68}
    };
    static const fourcc_t mjpg_codecs[] = { fccMJPG, fccmjpg, 0 };

    static const char* mjpeg_modes[] =
    {
	"Fast integer",	"Integer", "Float", 0
    };

    avm::vector<AttributeInfo> vs;

    vs.push_back(AttributeInfo("Mode", "Calculation precision mode", (const char**)mjpeg_modes));
    vs.push_back(AttributeInfo("LicenseKey", "License key", AttributeInfo::String));
    vs.push_back(AttributeInfo("UserName", "User name", AttributeInfo::String));
//    ci.push_back(CodecInfo(mjpg_codecs, "Motion JPEG DirectShow Decoder", 	"m3jpegdec.ax",mjpg_about, CodecInfo::DShow_Dec, &CLSID_MorganMjpeg, vs));

    /*
     missing  ICOpen
    ci.push_back(CodecInfo(mjpg_codecs, "Morgan Motion JPEG Direct Show",
			   "m3jpegdec.ax",
			   mjpg_about, CodecInfo::DShow_Dec,
			   CodecInfo::Video, CodecInfo::Decode,
			   &CLSID_MorganMjpeg, 0, vs));
    */

    ci.push_back(CodecInfo(mjpg_codecs, "Morgan Motion JPEG", "m3jpeg32.dll",
			   mjpg_about, CodecInfo::Win32, "morgands",
			   // this is actually not a morgands, but we don't care (?)
			   CodecInfo::Video,
			   // buggy - CompressBegin reference 0x0  FIXME
			   // CodecInfo::Both,
			   CodecInfo::Decode,
			   0, vs));


    /*
     * for encoding we are missing:
     * Called unk_wcscpy
     *
     * Support RGB24 only
     */
    ci.push_back(CodecInfo(mjpg_codecs, "MS Motion JPEG", "mcmjpg32.dll",
			   mjpg_about, CodecInfo::Win32, "mjpeg",
			   CodecInfo::Video, CodecInfo::Both
			   //CodecInfo::Video, CodecInfo::Decode
			  ));
}

static void add_pegas(avm::vector<CodecInfo>& ci)
{
    static const fourcc_t mjpg_codecs[] = { fccMJPG, fccmjpg, 0 };
    static const fourcc_t pvw2_codecs[] = {
	mmioFOURCC('P', 'V', 'W', '2'), 0 };
    static const fourcc_t pimj_codecs[] = {
	mmioFOURCC('P', 'I', 'M', 'J'), mmioFOURCC('J', 'P', 'G', 'L'), 0 };
    ci.push_back(CodecInfo(pvw2_codecs, "PicVideo   PVW2", "pvwv220.dll",
			   none_about, CodecInfo::Win32, "picvideo",
			   //CodecInfo::Video, CodecInfo::Both
			   CodecInfo::Video, CodecInfo::Decode
			  ));
    ci.push_back(CodecInfo(mjpg_codecs, "PicVideo   MJPG", "pvmjpg20.dll",
			   none_about, CodecInfo::Win32, "pv_mjpg",
			   //CodecInfo::Video, CodecInfo::Both
			   CodecInfo::Video, CodecInfo::Decode
			  ));
    ci.push_back(CodecInfo(pimj_codecs, "PicVideo   PIMJ", "pvmjpg20.dll",
			   none_about, CodecInfo::Win32, "pv_pimj",
			   //CodecInfo::Video, CodecInfo::Both
			   CodecInfo::Video, CodecInfo::Decode
			  ));

}

static void add_huffyuv(avm::vector<CodecInfo>& ci)
{
    static const char huffyuv_about[] =
	"Huffyuv is a very fast, lossless Win32 video "
	"codec. \"Lossless\" means that the output "
	"from the decompressor is bit-for-bit "
	"identical with the original input to the "
	"compressor. \"Fast\" means a compression "
	"throughput of up to 38 megabytes per second "
	"on author\'s 416 MHz Celeron."
	"Web site: <a href=\"http://http://www.math.berkeley.edu/~benrg/huffyuv.html\"></a>";

    static const fourcc_t huffyuv_codecs[] = { fccHFYU, 0 };
    static const char* huffyuv_modes[] =
    {
	"Predict left (fastest)",
	"Predict gradient",
	"Predict median (best)",
	0
    };

    avm::vector<AttributeInfo> vs;

    //vs.push_back(AttributeInfo("Mode", "Calculation precision mode", (const char**)mjpeg_modes));
    //ci.push_back(CodecInfo(mjpg_codecs, "Motion JPEG DirectShow Decoder", 	"m3jpegdec.ax",mjpg_about, CodecInfo::DShow_Dec, &CLSID_MorganMjpeg, vs));

    ci.push_back(CodecInfo(huffyuv_codecs, "Huffyuv lossless codec [HFYU]",
			   "huffyuv.dll",
			   huffyuv_about, CodecInfo::Win32, "huffyuv",
			   //CodecInfo::Video, CodecInfo::Decode));
			   CodecInfo::Video, CodecInfo::Both));
}

/* On2 Truemotion VP3.x support */
static void add_vp3(avm::vector<CodecInfo>& ci)
{
    /* The On2 copyright message taken from the Windows project
       resource file */
    static const char vp3_about[] =
	"<a href=\"http://www.vp3.com/\">VP3 Codec</a> "
	"- Version 3.2.1.0<br>\nCopyright \251 2001 <a "
	"href=\"http://www.on2.com/\">On2 "
	"Technologies</a>. All Rights Reserved.";
    static const fourcc_t apxx_codecs[] = { fccVP31, fccvp31, fccVP30, fccVP30,
    //fccTM20,
    0 };

    avm::vector<AttributeInfo> vs_empty; 
    avm::vector<AttributeInfo> ds;
    ds.push_back(AttributeInfo("strPostProcessingLevel", "Postprocessing",
			       AttributeInfo::Integer, 0, 8));
    /* vp3 codec contains a bug in ICDECOMPRESSEX initializer
    ( Codecs/vp31vfw/Win32/vp31vfw.h ) that breaks decoding upside-down
    images in 'normal' mode ( ICDECOMPRESS ) */
    ci.push_back(CodecInfo(apxx_codecs, "VP31\256 Compressor", "vp31vfw.dll",
			   vp3_about, CodecInfo::Win32Ex, "vp3",
			   CodecInfo::Video, CodecInfo::Both, 0, vs_empty, ds));
}

static void add_audio(avm::vector<CodecInfo>& ci)
{
    static const fourcc_t adpcm_codecs[] = { 2, 0 };
    ci.push_back(CodecInfo(adpcm_codecs, "MS ADPCM", "msadp32.acm",
			   "A Microsoft implementation of Adaptive "
			   "Differential Pulse Code Modulation (ADPCM), "
			   "a common digital audio format capable of "
			   "storing CD-quality audio.", CodecInfo::Win32, "msadpcm",
			   CodecInfo::Audio, CodecInfo::Decode));
/*
    static const fourcc_t imaadpcm_codecs[] = { 0x11, 0 };
    ci.push_back(CodecInfo(imaadpcm_codecs, "IMA ADPCM", "imaadp32.acm",
			   none_about, CodecInfo::Win32,
			   CodecInfo::Audio, CodecInfo::Decode));
*/
    static const GUID CLSID_Voxware =
    {
	0x73f7a062, 0x8829, 0x11d1,
	{ 0xb5, 0x50, 0x00, 0x60, 0x97, 0x24, 0x2d, 0x8d }
    };
    static const fourcc_t voxware_codecs[]={ 0x75, 0};
    ci.push_back(CodecInfo(voxware_codecs, "Voxware Metasound", "voxmsdec.ax",
			   none_about, CodecInfo::DShow_Dec, "voxware",
			   CodecInfo::Audio, CodecInfo::Decode,
			   &CLSID_Voxware));

    static const GUID CLSID_Acelp =
    {
	0x4009f700, 0xaeba, 0x11d1,
	{ 0x83, 0x44, 0x00, 0xc0, 0x4f, 0xb9, 0x2e, 0xb7 }
    };
    static const fourcc_t acelp_codecs[]={ 0x130, 0 };
    ci.push_back(CodecInfo(acelp_codecs, "ACELP.net", "acelpdec.ax",
			   "A net-based codec using frame-concatenation and "
			   "interlacing for improved music quality. "
			   "ACELP.net allows a dual-rate bit-rate of 8.5/6.5 "
			   "kbps or a fixed-rate bit-rate of 5.0 kbps.",
			   CodecInfo::DShow_Dec, "acelp", CodecInfo::Audio,
			   CodecInfo::Decode, &CLSID_Acelp));

    static const fourcc_t wma_codecs[] = { 0x160, 0x161, 0 };
    ci.push_back(CodecInfo(wma_codecs, "Windows Media Audio", "divxa32.acm",
			   "More fully known as Microsoft Windows Media(TM) "
			   "audio compression. This is the standard codec for "
			   "Microsoft Active Streaming Format which combines "
			   "fast encoding with high music quality and is "
			   "optimized for Pentium II (MMX) and Pentium III "
			   "(SSE/SIMD) processors. WM-AUDIO has a wide bit-rate "
			   "range from 5 kbps to 128 kbps and offers high quality "
			   "sound over the Internet even over 28.8 modems. "
                           "WM-AUDIO is considered a future replacement for MP3.",
			   CodecInfo::Win32, "divx", CodecInfo::Audio,
			   CodecInfo::Decode));

    static const fourcc_t imc_codecs[] = { 0x401, 0 };
    ci.push_back(CodecInfo(imc_codecs, "Intel Music Coder", "imc32.acm",
			   none_about, CodecInfo::Win32, "imc",
			   CodecInfo::Audio, CodecInfo::Decode));

    static const fourcc_t ima_codecs[] = { 0x11, 0 };
    ci.push_back(CodecInfo(ima_codecs, "IMA ADPCM", "imaadp32.acm",
			   "An implementation of ADPCM, useful for "
			   "cross-platform audio for multimedia, "
			   "developed by the Interactive Multimedia "
                           "Association (IMA).", CodecInfo::Win32, "ima",
			   CodecInfo::Audio, CodecInfo::Decode));
#if 0
    // codec ID ?
    static const fourcc_t anet_codecs[] = { 0x130, 0 };
    ci.push_back(CodecInfo(anet_codecs, "ANET", "sl_anet.acm",
			   "Sipro Lab Telcom Audio Codec",
			   CodecInfo::Win32, "anet",
			   CodecInfo::Audio, CodecInfo::Both));
#endif
    ci.push_back(CodecInfo(wma_codecs, "WMA dec", "wmadmod.dll",
			   "Winmedadio", CodecInfo::Win32, "wmadmod",
			   CodecInfo::Audio, CodecInfo::Decode));

    ci.push_back(CodecInfo(wma_codecs, "WMA enc", "wmadmoe.dll",
			   "Winmedadio", CodecInfo::Win32, "wmadmo_enc",
			   CodecInfo::Audio, CodecInfo::Encode));

    static const fourcc_t msn_codecs[] = { 0x32, 0 };
    ci.push_back(CodecInfo(msn_codecs, "Win32 MSN", "msnaudio.acm",
			   "MSN Audio codec", CodecInfo::Win32, "msnaudio",
			   CodecInfo::Audio, CodecInfo::Decode));
    static const fourcc_t gsm_codecs[] = { 0x31, 0x32, 0 };
    ci.push_back(CodecInfo(gsm_codecs, "Win32 GSM", "msgsm32.acm",
			   "MSN GSM Audio codec", CodecInfo::Win32, "msgsmacm",
			   CodecInfo::Audio, CodecInfo::Decode));

    static const fourcc_t lh_codecs[] = { 0x1101, 0x1102, 0x1103, 0x1104, 0 };
    ci.push_back(CodecInfo(lh_codecs, "Lernout & Hauspie", "lhacm.acm",
			   "Lernout & Hauspie  CELP, SCB", CodecInfo::Win32, "lhacm",
			   CodecInfo::Audio, CodecInfo::Decode));

    static const fourcc_t vorbis_codecs[] = { 0xFFFE, 0 };
    static const GUID vorbis_clsid =
    {
        0x6bA47966, 0x3F83, 0x4178,
	{0x96, 0x65, 0x00, 0xF0, 0xBF, 0x62, 0x92, 0xE5}
    };

    ci.push_back(CodecInfo(vorbis_codecs, "Win32 Vorbis decoder", "vorbis.acm",
			   "Vorbis Audio codec", CodecInfo::Win32, "vorbisacm",
			   CodecInfo::Audio, CodecInfo::Decode,
			   &vorbis_clsid));

#if 0
    // works now - but has some problems with buffering - somehow
    // we need to flash buffers after seek
    static const fourcc_t mpeg_codecs[] = { 0x55, 0 };
#if 0

    // DirectShow version causing segfault in Convert
    static const GUID CLSID_Mpeg =
    {
	0x38BE3000, 0xDBF4, 0x11D0,
	{ 0x86, 0x0e, 0x00, 0xA0, 0x24, 0xCF, 0xEF, 0x6D }
    };
    // DS doesn't work
    ci.push_back(CodecInfo(mpeg_codecs, "Win32 MPEG Layer-3 DS", "l3codecx.ax",
			   none_about, CodecInfo::DShow_Dec, "mp3_ds",
			   CodecInfo::Audio, CodecInfo::Decode,
			   &CLSID_Mpeg));
#endif
    // acm version is somewhat problematic - disable
    ci.push_back(CodecInfo(mpeg_codecs, "Win32 MPEG Layer-3", "l3codeca.acm",
			   none_about, CodecInfo::Win32, "mp3acm",
			   CodecInfo::Audio, CodecInfo::Decode));
#endif
#if 0
    // this works but only as a last resource - it has quite poor quality
    static const fourcc_t mpeg_codecs[] = { 0x55, 0 };
    ci.push_back(CodecInfo(mpeg_codecs, "MPEG Layer-3", "divxa32.acm",
			   none_about, CodecInfo::Win32, "divxmp3",
			   CodecInfo::Audio, CodecInfo::Decode));
#endif

}


static void libwin32_FillPlugins(avm::vector<CodecInfo>& ci)
{
    // disabled when crashing
    // add_angel(ci); - using divx instead
    add_divx(ci);
    add_divx4(ci);
    add_ati(ci);
    add_asus(ci);
    add_brooktree(ci);
    add_dvsd(ci);
    add_indeo(ci);
    add_morgan(ci);
    add_pegas(ci);
    add_huffyuv(ci);
    /* On2 Truemotion VP3.x support */
    add_vp3(ci);

    add_audio(ci);
    //0x5f3647a1, 0x8829, 0x11d1, 0xb5, 0x50, 0x00, 0x60, 0x97, 0x24, 0x2d, 0x8d};
    //0x46e32b01, 0x8829, 0x11d1, 0xb5, 0x50, 0x00, 0x60, 0x97, 0x24, 0x2d, 0x8d};
    //0x73f7a063, 0x8829, 0x11d1, 0xb5, 0x50, 0x00, 0x60, 0x97, 0x24, 0x2d, 0x8d};

    //const fourcc_t zero[]={ 0 };
    static const char mpg4_about[] =
	"Old beta version of Microsoft MPEG-4 "
	"video codec, incompatible with DivX ;-).";
    static const fourcc_t mpg4_codecs[]=
    {
	fccMP42, fccmp42, fccmp43,
        fccMPG4, fccmpg4, fccDIV2, fccdiv2, 0
    };
    ci.push_back(CodecInfo(mpg4_codecs, "Microsoft MPEG-4", "mpg4c32.dll",
			   mpg4_about, CodecInfo::Win32, "mpeg4"));

    static const char cvid_about[] =
	"Very old video codec, usually "
	"available as a part of Windows.";
    static const fourcc_t cvid_codecs[] = { fcccvid, 0 };
    ci.push_back(CodecInfo(cvid_codecs, "Cinepak Video", "iccvid.dll",
			   cvid_about, CodecInfo::Win32, "cvid"));

    static const fourcc_t i263_codecs[] = { fcci263, fccI263, 0 };
    ci.push_back(CodecInfo(i263_codecs,	"I263", "i263_32.drv",
			   none_about, CodecInfo::Win32, "i263"));

    static const fourcc_t mwv1_codecs[] = { fccMWV1, 0 };
    ci.push_back(CodecInfo(mwv1_codecs,	"Motion Wavelets",
			   "icmw_32.dll",
			   "Aware Motion Wavelets Video Codec [MWV1]",
			   CodecInfo::Win32, "mwv1",
			   CodecInfo::Video, CodecInfo::Both));

    static const fourcc_t mszh_codecs[] = { fccMSZH, 0 };
    ci.push_back(CodecInfo(mszh_codecs,	"AVI Mszh", "avimszh.dll",
			   none_about, CodecInfo::Win32, "mszh",
			   CodecInfo::Video, CodecInfo::Both));

    static const fourcc_t zlib_codecs[] = { fccZLIB, 0 };
    ci.push_back(CodecInfo(zlib_codecs,	"AVI Zlib", "avizlib.dll",
			   none_about, CodecInfo::Win32, "zlib",
			   CodecInfo::Video, CodecInfo::Both));

    static const fourcc_t m261_codecs[] = { fccM261, fccm261, 0 };
    ci.push_back(CodecInfo(m261_codecs,	"M261", "msh261.drv",
			   none_about, CodecInfo::Win32, "m261",
                           // crash with encode FIXME
			   CodecInfo::Video, CodecInfo::Decode));

    static const fourcc_t msrle_codecs[] = { 1, 0 };
    ci.push_back(CodecInfo(msrle_codecs, "MS RLE", "msrle32.dll",
			   none_about, CodecInfo::Win32, "msrlevfw",
			   CodecInfo::Video, CodecInfo::Both));

#if 0
    /*
     * crash with:  External func COMCTL32.dll:17 (SIGILL)
     */
    static const GUID CLSID_Tm20 =
    {
        0x4cb63e61, 0xc611, 0x11D0,
	{ 0x83, 0xaa, 0x00, 0x00, 0x92, 0x90, 0x01, 0x84 }
    };
    static const fourcc_t tm20_codecs[] = { fccTM20, 0 };
    ci.push_back(CodecInfo(tm20_codecs,	"TrueMotion 2.0 Decompressor",
			   "tm20dec.ax",
			   none_about, CodecInfo::DShow_Dec, "tm20",
			   CodecInfo::Video, CodecInfo::Decode,
			   &CLSID_Tm20));
#endif
    static const fourcc_t cram_codecs[] = { fccCRAM, fcccram, fccMSVC, 0 };
    // some of these are crashing
    ci.push_back(CodecInfo(cram_codecs,	"Microsoft Video 1", "msvidc32.dll",
			   none_about, CodecInfo::Win32, "cram",
                           // crash with encode query YUV  FIXME
                           CodecInfo::Video, CodecInfo::Decode));
}

#endif
