#ifndef AVIFILE_DS_AUDIODECODER_H
#define AVIFILE_DS_AUDIODECODER_H

#ifndef NOAVIFILE_HEADERS
#include "audiodecoder.h"
#include "except.h"
#else
#include "libwin32.h"
#endif
#include "DS_Filter.h"

class DS_AudioDecoder : public IAudioDecoder
{
public:
    DS_AudioDecoder(const CodecInfo& info, const WAVEFORMATEX*);
    virtual ~DS_AudioDecoder();
    virtual int Convert(const void*, uint_t, void*, uint_t, uint_t*, uint_t*);
    virtual uint_t GetMinSize();
#ifdef NOAVIFILE_HEADERS
    virtual uint_t GetSrcSize(uint_t);
#endif
protected:
    AM_MEDIA_TYPE m_sOurType, m_sDestType;
    DS_Filter* m_pDS_Filter;
    char* m_sVhdr;
    char* m_sVhdr2;
};

#endif // AVIFILE_DS_AUDIODECODER_H
