#ifndef AVIFILE_ACM_AUDIODECODER_H
#define AVIFILE_ACM_AUDIODECODER_H

#ifndef __WINE_MSACM_H
#include "wine/winerror.h"
#include "wine/msacm.h"
#endif

#ifndef NOAVIFILE_HEADERS
#include "audiodecoder.h"
#include "except.h"
#else
#include "libwin32.h"
#endif

class ACM_AudioDecoder : public IAudioDecoder
{
public:
    ACM_AudioDecoder(const CodecInfo&, const WAVEFORMATEX*);
    ~ACM_AudioDecoder();
    virtual uint_t GetMinSize();
    virtual uint_t GetSrcSize(uint_t dest_size);
    virtual int Convert(const void*, uint_t, void*, uint_t, uint_t*, uint_t*);
protected:
    WAVEFORMATEX wf;
    HACMSTREAM srcstream;
};

#endif //AVIFILE_ACM_AUDIODECODER_H
