/********************************************************

         Windows ACM-based audio decoder
	 Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/

#include "ACM_AudioDecoder.h"
#include "wineacm.h"
#include <string.h>
#include <stdio.h>


//#define TIMING
#define __MODULE__ "ACM_AudioDecoder"
//#define TIMING
//using namespace std;
/*char cfmt[]={0x61, 0x01, 0x02, 0x00, 0x22, 0x56, 0x00, 0x00,
0xa5, 0x0f, 0x00, 0x00, 0xba, 0x00, 0x10, 0x00,
0x0a, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00,
0xba, 0x00, 0x00, 0x00};*/

static int acmdrv = 0;

ACM_AudioDecoder::ACM_AudioDecoder(const CodecInfo& info, const WAVEFORMATEX* pwf)
    :IAudioDecoder(info, pwf)
{
    if (in_fmt.nSamplesPerSec == 0)
	throw FATAL("Bad argument");

    try
    {
	MSACM_RegisterDriver((const char*)info.dll, pwf->wFormatTag, 0);
	acmdrv++;

	wf.nChannels=in_fmt.nChannels;
	wf.nSamplesPerSec=in_fmt.nSamplesPerSec;
	wf.nAvgBytesPerSec=2*wf.nSamplesPerSec*wf.nChannels;
	wf.wFormatTag=WAVE_FORMAT_PCM;
	wf.nBlockAlign=2*in_fmt.nChannels;
	wf.wBitsPerSample=16;
	wf.cbSize=0;

	uint_t sz = sizeof(WAVEFORMATEX) + in_fmt.cbSize;
	char* wft = new char[sz];
	memcpy(wft, pwf, sz);

	HRESULT hr = acmStreamOpen(&srcstream, (HACMDRIVER)NULL,
				   (WAVEFORMATEX*)wft,
				   (WAVEFORMATEX*)&wf,
				   NULL, 0, 0, 0);
	//ACM_STREAMOPENF_NONREALTIME );
        delete[] wft;
	if (hr != S_OK)
	{
	    if (hr == ACMERR_NOTPOSSIBLE)
		throw FATAL("Unappropriate audio format");

	    throw FATAL("ACM_AudioDecoder: acmStreamOpen error %d", (int) hr);
	}
    }
    catch (FatalError& e)
    {
	if (--acmdrv == 0)
	    MSACM_UnregisterAllDrivers();
	throw;
    }
}

ACM_AudioDecoder::~ACM_AudioDecoder()
{
    acmStreamClose(srcstream, 0);
    if (--acmdrv == 0)
	MSACM_UnregisterAllDrivers();
}

int ACM_AudioDecoder::Convert(const void* in_data, uint_t in_size,
			      void* out_data, uint_t out_size,
			      uint_t* size_read, uint_t* size_written)
{
    HRESULT hr;
    DWORD srcsize;
//    printf("ACM_AudioDecoder: data starts with %X %X %X\n",
//        *(int*)in_data, *(int*)(in_data+4),  *(int*)(in_data+8));

#ifdef TIMING
    printf("ACM_AudioDecoder: received request to convert %d bytes to %d bytes\n",
	    in_size, out_size);
#endif
//    acmStreamSize(srcstream, in_size, &srcsize, ACM_STREAMSIZEF_SOURCE);
//    printf("%d\n", srcsize);
    acmStreamSize(srcstream, out_size, &srcsize, ACM_STREAMSIZEF_DESTINATION);
    if (srcsize > in_size)
	srcsize = in_size;
//    printf("%d\n", srcsize);
    ACMSTREAMHEADER ash;
    memset(&ash, 0, sizeof(ash));
    ash.cbStruct = sizeof(ash);
    ash.fdwStatus = 0;
    ash.dwUser = 0;
    (const void*) ash.pbSrc = in_data;
    ash.cbSrcLength = srcsize;
    ash.pbDst = (uint8_t*)out_data;
    ash.cbDstLength = out_size;

#ifdef TIMING
    printf("ACM_AudioDecoder: src: %X %X %X\n", ash.cbStruct, ash.cbSrcLength, ash.cbDstLength);
#endif
    hr = acmStreamPrepareHeader(srcstream, &ash, 0);
    if (hr != S_OK)
    {
	//cerr<<"ACM_AudioDecoder: acmStreamPrepareHeader error "<<hr<<endl;
	return hr;
    }

    hr = acmStreamConvert(srcstream, &ash, 0);
    if (hr == S_OK)
    {
	// printf("Uncompressed %d bytes from %d\n", ash.cbDstLengthUsed, ash.cbSrcLengthUsed);
	if (ash.cbSrcLengthUsed < in_size)
	    in_size = ash.cbSrcLengthUsed;
	out_size = ash.cbDstLengthUsed;
    }
    else
    {
	printf("ACM_AudioDecoder: acmStreamConvert error\n");
        out_size = 0;
    }
    acmStreamUnprepareHeader(srcstream, &ash, 0);
    if (size_read)
	*size_read = in_size;
    if (size_written)
	*size_written = out_size;

    return hr;
}

uint_t ACM_AudioDecoder::GetMinSize()
{
    long in_size=in_fmt.nBlockAlign;
    DWORD srcsize = 0;

    acmStreamSize(srcstream, in_size, &srcsize, ACM_STREAMSIZEF_SOURCE);
//    if(!zz){zz=1;
//    cerr.setf(ios::dec, ios::basefield);
//    cerr<<"Audio data block align "<<in_size<<" ; minimal buffer size "<<srcsize<<endl;
//    }
    return srcsize;
}


uint_t ACM_AudioDecoder::GetSrcSize(uint_t dest_size)
{
    long in_size = in_fmt.nBlockAlign;
    uint_t srcsize = 0;
    acmStreamSize(srcstream, dest_size, (DWORD*) &srcsize, ACM_STREAMSIZEF_DESTINATION);

    //printf("ACM %d  %d\n", srcsize, IAudioDecoder::GetSrcSize(dest_size));
    return srcsize;
}

