#ifndef LIBMPEG_AUDIODEC_FILLPLUGINS_H
#define LIBMPEG_AUDIODEC_FILLPLUGINS_H

#include "infotypes.h"

static void libmpeg_audiodec_FillPlugins(avm::vector<CodecInfo>& audiocodecs)
{
    static const fourcc_t mpeg_codecs[] = { 0x50, 0x55, 0 };
    audiocodecs.push_back(CodecInfo(mpeg_codecs, "MPEG Layer-3", "",
				    "Also known as MP3. This is the third coding "
				    "scheme for MPEG audio compression. MPEG Layer-3 "
				    "uses perceptual audio coding and psychoacoustic "
                                    "compression to remove parts of the audio "
				    "signal that are imperceptible to the human ear. "
				    "The result is a compression ratio up to 12:1 "
				    "without loss of audio quality. MP3 is a common "
				    "format for distributing music files over the Internet.",
				    CodecInfo::Plugin, "mp3splay", CodecInfo::Audio, CodecInfo::Decode));
}

#endif /* LIBMPEG_AUDIODEC_FILLPLUGINS_H */
