#include <audioencoder.h>

#include "lame.h"

class LameEncoder: public IAudioEncoder
{
    lame_global_flags* gf;
    WAVEFORMATEX in_fmt;
    int brate;
    void* handle;

    /* lame calls */
    lame_global_flags * CDECL (*p_lame_init)(void);
    int CDECL (*p_lame_init_params)(lame_global_flags *);
    int CDECL (*p_lame_set_padding_type)(lame_global_flags *, Padding_type);
    int CDECL (*p_lame_set_VBR)(lame_global_flags *, vbr_mode);
    int CDECL (*p_lame_set_in_samplerate)(lame_global_flags *, int);
    int CDECL (*p_lame_set_num_channels)(lame_global_flags *, int);
    int CDECL (*p_lame_set_mode)(lame_global_flags *, MPEG_mode);
    int CDECL (*p_lame_set_brate)(lame_global_flags *, int);
    int CDECL (*p_lame_set_quality)(lame_global_flags *, int);
    int CDECL (*p_lame_get_framesize)(const lame_global_flags *);
    int CDECL (*p_lame_encode_finish)(lame_global_flags*  gfp,
				    unsigned char*      mp3buf,
				    int                 size);
    int CDECL (*p_lame_encode_buffer)(lame_global_flags*  gfp,
				      const short int     buffer_l [],
				      const short int     buffer_r [],
				      const int           nsamples,
				      unsigned char*      mp3buf,
				      const int           mp3buf_size);
    int CDECL (*p_lame_encode_buffer_interleaved)(lame_global_flags*  gfp,
						  short int           pcm[],
						  int                 num_samples,
						  unsigned char*      mp3buf,
						  int                 mp3buf_size);


public:
    LameEncoder(const CodecInfo& info, const WAVEFORMATEX* format);
    ~LameEncoder();
    virtual int SetBitrate(int bitrate);
    virtual int SetQuality(int quality);
    virtual uint_t GetFormat(void* extension = 0, uint_t size = 0) const;
    virtual int Start();
    virtual int Convert(const void* in_data, uint_t in_size,
			void* out_data, uint_t out_size,
			uint_t* size_read, uint_t* size_written);
private:
    virtual int Close(void* out_data, uint_t out_size, uint_t* size_read);
    void* dlsymm(const char* symbol, bool fatal = true);
};
