#include <audioencoder.h>

extern "C"
{
#include "lame3.70/lame.h"
}

class MP3Encoder: public IAudioEncoder
{
    lame_global_flags gf;
    WAVEFORMATEX in_fmt;
public:
    MP3Encoder(const CodecInfo& info, const WAVEFORMATEX* format);
    ~MP3Encoder();
    virtual int SetBitrate(int bitrate);
    virtual int SetQuality(int quality);
    virtual uint_t GetFormat(void* extension = 0, uint_t size = 0) const;
    virtual int Start();
    virtual int Convert(const void* in_data, uint_t in_size,
			void* out_data, uint_t out_size,
			uint_t* size_read, uint_t* size_written);
    virtual int Close(void* out_data, uint_t out_size, uint_t* size_read);
};
