#ifndef LIBFFMPEG_FILLPLUGINS_H
#define LIBFFMPEG_FILLPLUGINS_H

#include "infotypes.h"
#include "fourcc.h"

static void libffmpeg_add_divx(avm::vector<CodecInfo>& ci)
{
    static const char divx_about[] =
	"FFMPEG GPL version of popular MPEG-4 video codec. "
	"Advanced compression technologies allow it to "
	"compress 640x480x25 video with a perfect "
	"quality into 100-150 kbytes/s ( 3-4 times "
	"less than MPEG-2 ).<br>";

    static const fourcc_t div3_codecs[] = { fccDIV3, fccdiv3, fccDIV4, fccdiv4,
    				       fccDIV5, fccdiv5, fccDIV6, fccdiv6,
                                       fccMP41, fccMP43, 
    				       fccAP41, fccap41, fccAP42, fccap42,
				       0 };

#if 0
    avm::vector<AttributeInfo> vs;
    avm::vector<AttributeInfo> ds;
    vs.push_back("BitRate");
    vs.push_back("Crispness");
    vs.push_back("KeyFrames");
    ds.push_back(AttributeInfo("Quality", "Quality/CPU balance ( 0 fastest )", AttributeInfo::Integer, 0, 4));

    avm::vector<AttributeInfo> ds1;
    ds1.push_back(AttributeInfo("Quality", "Quality/CPU balance ( 0 fastest )", AttributeInfo::Integer, 0, 4));
    ds1.push_back(AttributeInfo("Saturation", "Saturation", AttributeInfo::Integer, 0, 100));
    ds1.push_back(AttributeInfo("Hue", "Hue", AttributeInfo::Integer, 0, 100));
    ds1.push_back(AttributeInfo("Brightness", "Brightness", AttributeInfo::Integer, 0, 100));
    ds1.push_back(AttributeInfo("Contrast", "Contrast", AttributeInfo::Integer, 0, 100));
#endif

    // for encoding
    ci.push_back(CodecInfo(div3_codecs, "FFMPEG DivX ;-)", "",
			   divx_about, CodecInfo::Plugin, "ffdivx",
			   CodecInfo::Video, CodecInfo::Decode // for now
			  ));
}

static void libffmpeg_add_opendivx(avm::vector<CodecInfo>& ci)
{
    static const char opendix_about[] = "FFMPEG OpenDivX MPEG-4";
    static const fourcc_t opendix_codecs[] = { fccDIVX, fccdivx, fccDIV1, fccdiv1, fccMP4S, fccmp4s, 0x4, 0 };
    ci.push_back(CodecInfo(opendix_codecs, "FFMPEG OpenDivX", "",
			   opendix_about, CodecInfo::Plugin, "ffodivx",
			   CodecInfo::Video,
			   CodecInfo::Decode // for now
			  ));
}

static void libffmpeg_add_mjpeg(avm::vector<CodecInfo>& ci)
{
    static const fourcc_t mjpg_codecs[] = { fccMJPG, fccmjpg, 0 };
    ci.push_back(CodecInfo(mjpg_codecs, "FFMPEG Motion JPEG", "",
			   "", CodecInfo::Plugin, "ffmjpeg", 
			   CodecInfo::Video, CodecInfo::Decode));
}

static void libffmpeg_add_263(avm::vector<CodecInfo>& ci)
{
    static const fourcc_t u263_codecs[] = { fccU263, fccu263, fcch263, fccH263, 0 };
    ci.push_back(CodecInfo(u263_codecs, "FFMPEG U263", "",
			   "", CodecInfo::Plugin, "ffh263",
			   CodecInfo::Video, CodecInfo::Decode));
    static const fourcc_t i263_codecs[] = { fcci263, fccI263, 0 };
    ci.push_back(CodecInfo(i263_codecs, "FFMPEG I263", "",
			   "", CodecInfo::Plugin, "ffi263",
			   CodecInfo::Video, CodecInfo::Decode));
}

static void libffmpeg_add_ac3dec(avm::vector<CodecInfo>& ci)
{
    static const fourcc_t ac3_codecs[]={ 0x2000, 0 };
    ci.push_back(CodecInfo(ac3_codecs, "FFMPEG AC3", "",
			   "", CodecInfo::Plugin, "ffac3",
			   CodecInfo::Audio, CodecInfo::Decode));
}

static void libffmpeg_add_mp3dec(avm::vector<CodecInfo>& ci)
{
    static const fourcc_t mpg_codecs[]={ 0x55, 0x50, 0 };
    ci.push_back(CodecInfo(mpg_codecs, "FFMPEG MPEG Layer-3", "",
			   "", CodecInfo::Plugin,  "ffmp3",
			   CodecInfo::Audio, CodecInfo::Decode));
}

static void libffmpeg_FillPlugins(avm::vector<CodecInfo>& ci)
{
#ifdef USE_FFMPEG_DIVX
    libffmpeg_add_divx(ci);
    libffmpeg_add_opendivx(ci);
#endif
    libffmpeg_add_mjpeg(ci);
    libffmpeg_add_263(ci);

#ifdef USE_FFMPEG_AC3
    // there might be certain legality problems
    // for mainstream Debian relase binary is without AC3 decoder
    libffmpeg_add_ac3dec(ci);
#endif
    libffmpeg_add_mp3dec(ci);
}

#endif //LIBFFMPEG_FILLPLUGINS_H
