#ifndef AVIFILE_FFVIDEODECODER_H
#define AVIFILE_FFVIDEODECODER_H

#include "videodecoder.h"

#ifndef EXTRA_AVCODEC_H
#define EXTRA_AVCODEC_H
extern "C"
{
#include "libavcodec/avcodec.h"
}
#endif // EXTRA_AVCODEC_H

class FFVideoDecoder: public IVideoDecoder
{
public:
    FFVideoDecoder(AVCodec* av,const CodecInfo& info, const BITMAPINFOHEADER& format, int flip);
    ~FFVideoDecoder();
    virtual int SetDestFmt(int bits = 24, fourcc_t csp = 0);
    virtual CAPS GetCapabilities() const { return m_Caps; }
protected:
    virtual int DecodeInternal(const void* src, uint_t size, int is_keyframe, CImage* pImage);
    virtual void StartInternal();
    virtual void StopInternal();
    CAPS m_Caps;
    bool m_bOpened;

    AVCodec *m_pAvCodec;
    AVCodecContext m_AvContext;
    AVPicture m_AvPicture;
};

#endif //AVIFILE_FFVIDEODECODER_H
