#ifndef AVIFILE_FFAUDIODECODER_H
#define AVIFILE_FFAUDIODECODER_H

#include "audiodecoder.h"

#ifndef EXTRA_AVCODEC_H
#define EXTRA_AVCODEC_H
extern "C"
{
#include "libavcodec/avcodec.h"
}
#endif // EXTRA_AVCODEC_H

// used currently for AC3 stream

class FFAudioDecoder: public IAudioDecoder
{
    static const uint_t MIN_AC3_CHUNK_SIZE = 8192;
    AVCodec *m_pAvCodec;
    AVCodecContext m_AvContext;
public:
    FFAudioDecoder(AVCodec*, const CodecInfo&, const WAVEFORMATEX*);
    ~FFAudioDecoder();
    virtual uint_t GetMinSize();
    virtual int Convert(const void*, uint_t, void*, uint_t, uint_t*, uint_t*);
};

#endif //AVIFILE_FFAUDIODECODER_H
