// do not use ffmpeg's config here !
#include "../../include/config.h"
#include "FFAudioDecoder.h"
#include "except.h"
#include <stdio.h>

#define __MODULE__ "FFAudioDecoder"

FFAudioDecoder::FFAudioDecoder(AVCodec* av, const CodecInfo& info, const WAVEFORMATEX* in)
    :IAudioDecoder(info, in)
{
    printf("FFMPEG Audio decoder\n");
    m_pAvCodec = av;

    if (avcodec_open(&m_AvContext, m_pAvCodec) < 0)
	throw FATAL("can't open avcodec");
}

FFAudioDecoder::~FFAudioDecoder()
{
    avcodec_close(&m_AvContext);
}

int FFAudioDecoder::Convert(const void* in_data, uint_t in_size,
			    void* out_data, uint_t out_size,
			    uint_t* size_read, uint_t* size_written)
{
    if (!in_data || !out_data)
	return -1;

    int framesz;
    int hr = avcodec_decode_audio(&m_AvContext, (int16_t*)out_data, &framesz,
				  (uint8_t*)in_data, in_size);
    if (hr < 0)
        return -1;

    if (size_read)
	*size_read = hr;
    if (size_written)
	*size_written = framesz;

    return 0;
}

uint_t FFAudioDecoder::GetMinSize()
{
    switch (record.fourcc)
    {
    case 0x2000:
	return MIN_AC3_CHUNK_SIZE;
    default:
	return 2;
    }
}
