#ifndef LIBDIVX4_FILLPLUGINS_H
#define LIBDIVX4_FILLPLUGINS_H

#define USE_311_DECODER
#include "infotypes.h"
#include "fourcc.h"
#ifdef HAVE_LIBDIVXDECORE
#include "decore.h"
#ifdef BIG_ENDIAN
#undef BIG_ENDIAN
#endif
#endif

static void libdivx4_FillPlugins(avm::vector<CodecInfo>& ci)
{
    /* divx is able to decode large variety of formats */
    static const fourcc_t div3_codecs[] = { fccDIV3, fccdiv3, fccDIV4, fccdiv4,
    				       fccDIV5, fccdiv5, fccDIV6, fccdiv6,
				       /* untested, may work */
				       fccMP43, fccmp43,
				       //fccWMV2,
				       0 };

    static const fourcc_t divx_codecs[] =
    {
	fccDIVX, fccdivx, fccDIV1, fccdiv1, fccMP4S, fccmp4s, 0x4, 0
    };
    static const fourcc_t divxall_codecs[] = 
    { fccDIV3, fccdiv3, fccDIV4, fccdiv4,
            fccDIV5, fccdiv5, fccDIV6, fccdiv6,
       /* untested, may work */
    	    fccMP43, fccmp43,
	    fccDIVX, fccdivx, fccDIV1, fccdiv1, fccMP4S, fccmp4s, 0x4, 0
    };
    
    static char divx_about[] = "DivX 4.0";

// FIFO order is important - if this will ever change - few things
// would have to be repaired

    avm::vector<AttributeInfo> vs;
    vs.push_back(AttributeInfo("BitRate",
			       "Desired stream bit-rate in bits/second",
			       AttributeInfo::Integer));
    vs.push_back(AttributeInfo("rc_period",
			       "Unknown", AttributeInfo::Integer));
    vs.push_back(AttributeInfo("min_quantizer",
			       "Unknown", AttributeInfo::Integer));
    vs.push_back(AttributeInfo("max_quantizer",
			       "Unknown", AttributeInfo::Integer));
    vs.push_back(AttributeInfo("quality",
			       "Performance/quality balance",
			       AttributeInfo::Integer));
    vs.push_back(AttributeInfo("deinterlace", "Deinterlace",
			       AttributeInfo::Integer));
#ifdef ENC_MAJOR_VERSION
    vs.push_back(AttributeInfo("bidirect", "bidirectional encoding", AttributeInfo::Integer, 0, 1));
#endif

    avm::vector<AttributeInfo> ds;
    ds.push_back(AttributeInfo("Post-processing",
			       "Image post-processing mode ( 6 slowest )",
			       AttributeInfo::Integer, 0, 6));
    ds.push_back(AttributeInfo("MaxAuto", "Maximum autoquality level",
			       AttributeInfo::Integer, 0, 6));
#ifdef DEC_OPT_GAMMA			       
    ds.push_back(AttributeInfo("Saturation", "Saturation",
			       AttributeInfo::Integer, -128, 127));
    ds.push_back(AttributeInfo("Brightness", "Brightness",
			       AttributeInfo::Integer, -128, 127));
    ds.push_back(AttributeInfo("Contrast", "Contrast",
			       AttributeInfo::Integer, -128, 127));
#endif
    ci.push_back(CodecInfo(divx_codecs, "DivX 4.0", "", divx_about,
			   CodecInfo::Plugin, "odivx4", CodecInfo::Video,
			   CodecInfo::Both, 0, vs, ds));

#ifdef USE_311_DECODER
    ci.push_back(CodecInfo(divxall_codecs, "OpenDivX 3.11 compatible decoder",
			   "", divx_about, CodecInfo::Plugin, "odivx",
			   CodecInfo::Video, CodecInfo::Decode, 0, vs, ds));
#endif
}

#endif // LIBDIVX4_FILLPLUGINS_H
