// moved to fillplugin #define USE_311_DECODER

#include "fillplugins.h"

#include <encore2.h>
#include <decore.h>

#include "videodecoder.h"
#include "videoencoder.h"
#include "fourcc.h"
#include "configfile.h"
#include "plugin.h"
#include "Locker.h"

#include <stdio.h>
#include <string.h> // memset
#include <stdlib.h> // labs

static avm::string error;

extern "C" int quiet_encore;

#define MAX_QUALITY 6
//#define CONST_VOID (const void*)
static const char* strOpendivx = "opendivx";
static const char* strPostProcessing = "Post-processing";
static const char* strBrightness = "Brightness";
static const char* strSaturation = "Saturation";
static const char* strContrast = "Contrast";
static const char* strMaxAuto = "MaxAuto";
static const char* strBitRate = "BitRate";
static const char* strDeinterlace = "deinterlace";

class DIVX_VideoDecoder: public IVideoDecoder, public IRtConfig
{
    int m_iState;
    int m_iLastPPMode;
    int m_iMaxAuto;
    bool m_bCompat311;
//    bool m_bCompatWMV2;
    PthreadMutex m_Pm;
    char m_cFormatBuf[128];
    int m_iLastBrightness;
    int m_iLastContrast;
    int m_iLastSaturation;
public:
    DIVX_VideoDecoder(const CodecInfo& info, const BITMAPINFOHEADER& bh, int flip)
	:IVideoDecoder(info,bh), m_iState(0), m_iLastPPMode(0),
	m_iLastBrightness(0), m_iLastContrast(0), m_iLastSaturation(0)
    {
//	switch(info.fourcc)
	switch(bh.biCompression)
	{
#ifdef USE_311_DECODER
	case fccdiv3:
	case fccDIV3:
	case fccdiv4:
	case fccDIV4:
	case fccdiv5:
	case fccDIV5:
	case fccdiv6:
	case fccDIV6:
	case fccMP41:
	case fccMP43:
	    m_bCompat311=true;
//	    m_bCompatWMV2=false;
	    break;
//	case fccWMV2:
//	    m_bCompat311=true;
//	    m_bCompatWMV2=true;
//	    break;
#endif
	default:
	    m_bCompat311=false;
	    break;
	}
//	m_bh=bh;
	m_obh=bh;
	memcpy(m_cFormatBuf,  ((const char*)&bh) + sizeof(BITMAPINFOHEADER),
	    bh.biSize-sizeof(BITMAPINFOHEADER));
	if(!flip)
	    m_obh.biHeight*=-1;
	m_obh.SetBits(24);
	m_decoder=BitmapInfo(m_obh.biWidth, m_obh.biHeight, 24);
	VBUFSIZE += 7;
	m_iMaxAuto = Registry::ReadInt(strOpendivx, strMaxAuto, 0);
    }
    virtual ~DIVX_VideoDecoder()
    {
	Stop();
    }
    virtual void StartInternal()
    {
	{
	    Locker locker(m_Pm);
	    DEC_PARAM param;
	    int csp = m_obh.biCompression;
	    //	printf("csp: 0x%x bitcount: %d height: %d\n", csp, m_obh.biBitCount, m_obh.biHeight);
	    //use ?? SetDestFmt(m_obh.biBitCount, 0);

	    m_decoder.biHeight=m_obh.biHeight;
#if 1
	    if (csp == 0 || csp == 3)
	    {
		param.output_format=(m_obh.biHeight>0)?DEC_RGB555:DEC_RGB555_INV;
		//cout << "BITCOUNT " << m_obh.biBitCount << endl;
		switch (m_obh.biBitCount)
		{
		case 15:
		    param.output_format=(m_obh.biHeight>0)?DEC_RGB555:DEC_RGB555_INV;
		    break;
		case 16:
		    param.output_format=(m_obh.biHeight>0)?DEC_RGB565:DEC_RGB565_INV;
		    break;
		case 24:
		    param.output_format=(m_obh.biHeight>0)?DEC_RGB24:DEC_RGB24_INV;
		    break;
		case 32:
		    param.output_format=(m_obh.biHeight>0)?DEC_RGB32:DEC_RGB32_INV;
		    break;
		default:
		    return;
		}
	    }
	    else
	    {
		//printf("CSP  %x   %.4s\n", csp, (char*)&csp);
		switch(csp)
		{
		case fccYV12:
		    param.output_format=DEC_YV12;
		    break;
		case fccYUY2:
		    param.output_format=DEC_YUV2;
		    break;
		}
	    }
#endif
	    param.x_dim=m_obh.biWidth;
	    param.y_dim=labs(m_obh.biHeight);
	    param.time_incr = 15;
	    // DEC_MEM_REQS dmr;
	    // decore((unsigned long)this, DEC_OPT_MEMORY_REQS, &dmr, 0);
	    memset(&param.buffers, 0, sizeof(param.buffers));
	    decore((unsigned long)this, DEC_OPT_INIT, &param, m_cFormatBuf);
	    m_iState = 1;
	}
	int v  = Registry::ReadInt(strOpendivx, strPostProcessing, 0);
        SetValue(strPostProcessing, v);
	SetValue(strSaturation, Registry::ReadInt(strOpendivx, strSaturation, 0));
        SetValue(strBrightness, Registry::ReadInt(strOpendivx, strBrightness, 0));
        SetValue(strContrast, Registry::ReadInt(strOpendivx, strContrast, 0));
    }
    virtual CAPS GetCapabilities() const
    {
	return CAPS(CAP_YV12|CAP_YUY2);
    }
    virtual void StopInternal()
    {
	Locker locker(m_Pm);
	if (!m_iState)
	    return;
	decore((unsigned long)this, DEC_OPT_RELEASE, 0, 0);
        m_iState = 0;
	Registry::WriteInt(strOpendivx, strSaturation, m_iLastSaturation);
	Registry::WriteInt(strOpendivx, strBrightness, m_iLastBrightness);
	Registry::WriteInt(strOpendivx, strContrast, m_iLastContrast);
    }
    virtual int DecodeInternal(const void* src, uint_t size, int is_keyframe, CImage* pImage)
    {
	{
	    Locker locker(m_Pm);
	    if(!size || !m_iState)
		return 0;
	    DEC_FRAME param;
            // leave here for some time - until all users will use new headers
	    param.bitstream = (void*) src;
	    unsigned char* pc[3];
	    param.bmp=pImage?pImage->Data():0;
	    param.length=size;
	    param.render_flag=pImage?1:0;
	    param.stride=pImage?pImage->Width():0;

#ifdef USE_311_DECODER
	    if(m_bCompat311)
	    {
//		if(m_bCompatWMV2)
//		    decore((unsigned long)this, DEC_OPT_FRAME_WMV2, &param, 0);
//		else
		decore((unsigned long)this, DEC_OPT_FRAME_311, &param, 0);
	    }
	    else
#endif
	    {
		decore((unsigned long)this, DEC_OPT_FRAME, &param, 0);
	    }
	    m_fQuality = (float) m_iLastPPMode / MAX_QUALITY;
	}
	if (m_Mode == IVideoDecoder::BUFFERED_QUALITY_AUTO)
	{
	    // adjust Quality - depends on how many cached frames we have
	    int buffered = m_iDecpos - m_iPlaypos;

	    //cout << "qual " << q << "  " << buffered << endl;
	    if (buffered < (m_iLastPPMode + 1)
		|| buffered > (m_iLastPPMode + 1))
	    {
		// removed old code which was present here
		// and replaced with this new uptodate one

		int to = buffered - 1;
		if (to < 0)
		    to = 0;
		else if (to > m_iMaxAuto)
		    to = m_iMaxAuto;
		if (m_iLastPPMode != to)
                    SetValue("Post-processing", to);
	    }
	}
        return 0;
    }
    virtual int SetDestFmt(int bits = 24, fourcc_t csp = 0)
    {
	DEC_PARAM param;
	{
	    Locker locker(m_Pm);
	    if (csp)
		switch(csp)
		{
		case fccYV12:
		    param.output_format=DEC_YV12;
		    break;
		case fccYUY2:
		    param.output_format=DEC_YUV2;
		    break;
		default:
		    return -1;
		}
	    else
	    {
		switch(bits)
		{
		case 15:
		    param.output_format=DEC_RGB555_INV;
		    break;
		case 16:
		    param.output_format=DEC_RGB565_INV;
		    break;
		case 24:
		    param.output_format=DEC_RGB24_INV;
		    break;
		case 32:
		    param.output_format=DEC_RGB32_INV;
		    break;
		default:
		    return -1;
		}
	    }
	    if (m_iState)
		decore((unsigned long)this, DEC_OPT_SETOUT, &param, 0);
	    if(csp)
	    {
		m_obh.SetSpace(csp);
		m_decoder.SetSpace(csp);
	    }
	    else
	    {
		m_obh.SetBits(bits);
		m_decoder.SetBits(bits);
	    }
	}
	if (m_iState)
	    Restart();
	return 0;
    }
    virtual HRESULT GetValue(const char* name, int& value)
    {
	if (strcmp(name, strPostProcessing) == 0)
	{
	    value = m_iLastPPMode;
            return 0;
	}
	else if (strcmp(name, strMaxAuto) == 0)
	{
	    value = m_iMaxAuto;
            return 0;
	}
	else if (strcmp(name, strBrightness) == 0)
	{
	    value = m_iLastBrightness;
	    return 0;
	}
	else if (strcmp(name, strContrast) == 0)
	{
	    value = m_iLastContrast;
	    return 0;
	}
	else if (strcmp(name, strSaturation) == 0)
	{
	    value = m_iLastSaturation;
	    return 0;
	}
	return -1;
    }
    virtual HRESULT SetValue(const char* name, int value)
    {
	if (strcmp(name, strPostProcessing) == 0)
	{
	    DEC_SET set;
	    Locker locker(m_Pm);
	    set.postproc_level=value*10;
	    if (decore((unsigned long)this, DEC_OPT_SETPP, &set, 0)==DEC_OK)
	    {
		m_iLastPPMode=value;
		return 0;
	    }
	}
	else if (strcmp(name, strMaxAuto) == 0 && value >= 0 && value <= 6)
	{
	    m_iMaxAuto = value;
	    int r = Registry::WriteInt(strOpendivx, strMaxAuto, value);
            return r;
	}
	else if (strcmp(name, strBrightness) == 0 && value >= -128 && value <= 127)
	{
	    m_iLastBrightness = value;
#ifdef DEC_OPT_GAMMA
	    decore((unsigned long)this, DEC_OPT_GAMMA, (void*)DEC_GAMMA_BRIGHTNESS, (void*)value);
#endif
	    return 0;
	}
	else if (strcmp(name, strContrast) == 0 && value >= -128 && value <= 127)
	{
	    m_iLastContrast = value;
#ifdef DEC_OPT_GAMMA
	    decore((unsigned long)this, DEC_OPT_GAMMA, (void*)DEC_GAMMA_CONTRAST, (void*)value);
#endif
	    return 0;
	}
	else if (strcmp(name, strSaturation) == 0 && value >= -128 && value <= 127)
	{
	    m_iLastSaturation = value;
#ifdef DEC_OPT_GAMMA
	    decore((unsigned long)this, DEC_OPT_GAMMA, (void*)DEC_GAMMA_SATURATION, (void*)value);
#endif
	    return 0;
	}
	return -1;
    }
};

class DIVX_VideoEncoder: public IVideoEncoder
{
    BITMAPINFOHEADER m_bh;
    BITMAPINFOHEADER m_obh;
    int m_iState;
    void* m_pHandle;
    bool m_bRtMode;
    int m_iQuant;
public:
    DIVX_VideoEncoder(const CodecInfo& info, int compressor, const BITMAPINFOHEADER& bh)
	:IVideoEncoder(info), m_bh(bh), m_obh(bh), m_iState(0), m_bRtMode(false)
    {
        printf("DivX4 linux encoder\n");

	if (m_bh.biCompression == 0 && m_bh.biBitCount != 24)
	    error = "Unsupported input bit depth";
	switch (m_bh.biCompression)
	{
	case 0:
	case fccYUY2:
	case fccYV12:

	case fccDIVX:
	    break;
	default:
	    error = "Unsupported input format";
	    break;
	}
	m_obh.biCompression = mmioFOURCC('D', 'I', 'V', 'X');
	m_obh.biHeight = labs(m_obh.biHeight);
	quiet_encore = 1;
    }
    virtual ~DIVX_VideoEncoder() {}
    virtual int SetQuality(int quality)
    {
	printf("quality: %d\n", quality);
	Registry::WriteInt(strOpendivx, "quality2", quality);
	return 0;
    }
    virtual int GetQuality()
    {
	return Registry::ReadInt(strOpendivx, "quality2", 8500);
    }
    virtual void Start()
    {
	ENC_PARAM param;
	memset(&param, 0, sizeof(param));
	param.x_dim=m_bh.biWidth;
	param.y_dim=labs(m_bh.biHeight);
	param.framerate=30;//frames/sec
	param.bitrate=Registry::ReadInt(strOpendivx, strBitRate, 800000);;//bits/sec
	param.rc_period=Registry::ReadInt(strOpendivx, "rc_period", 200);
	param.max_quantizer=Registry::ReadInt(strOpendivx, "max_quantizer", 16);//just guess
	param.min_quantizer=Registry::ReadInt(strOpendivx, "min_quantizer", 1);
	param.quality=Registry::ReadInt(strOpendivx, "quality", 0);
#ifndef ENCORE_MAJOR_VERSION	
        param.use_bidirect=0;
#else
	param.extensions.use_bidirect=Registry::ReadInt(strOpendivx, "bidirect", 0);	
#endif
        param.deinterlace=Registry::ReadInt(strOpendivx, strDeinterlace, 0);
	if(param.quality==1)
	{
	    m_bRtMode=true;
	    int quality=GetQuality();
	    m_iQuant=int(1+.003*(10000-quality));
	    printf("New quant: %d\n", m_iQuant);
	    if(m_iQuant>31)
		m_iQuant=31;
	    if(m_iQuant<1)
		m_iQuant=1;
	}
	else
	    m_bRtMode=false;
//	param.flip=1;
	encore(0, ENC_OPT_INIT, &param, 0);
	m_pHandle=param.handle;
	m_iState=1;
    }
    virtual void Stop()
    {
	if(!m_iState)return;
	encore(m_pHandle, ENC_OPT_RELEASE, 0, 0);
	m_iState=0;
	m_pHandle=0;
    }
    virtual int GetOutputSize() const
    {
	return labs(m_bh.biWidth*m_bh.biHeight)*4;
    }
    virtual const BITMAPINFOHEADER& GetOutputFormat() const
    {
	return m_obh;
    }
    virtual int EncodeFrame(const CImage* sRc, void* dest, int* is_keyframe, uint_t* size, int* lpckid=0)
    {
	ENC_FRAME param;
	ENC_RESULT result;
	param.bitstream=dest;
	switch(m_bh.biCompression)
	{
	case 0:
	    param.colorspace=ENC_CSP_RGB24;
	    break;
	case fccYUY2:
	    param.colorspace=ENC_CSP_YUY2;
	    break;
	case fccYV12:
	    param.colorspace=ENC_CSP_I420;
	    break;
	}
	 param.image = (void*) sRc->Data();
	param.mvs=0;
	param.length=sRc->Width() * sRc->Height() * 6;
	if(m_bRtMode)
	{
	    param.quant=m_iQuant;
	    param.intra=-1;
	    encore(m_pHandle, ENC_OPT_ENCODE_VBR, &param, &result);
	}
	else
	    encore(m_pHandle, ENC_OPT_ENCODE, &param, &result);
	if(is_keyframe)*is_keyframe=result.is_key_frame?16:0;
	if(size)*size=param.length;
	return 0;
    }
};

static avm::vector<CodecInfo> s_plugin_props;

extern "C" const avm::vector<CodecInfo>& RegisterPlugin()
{
    if (!s_plugin_props.size())
	libdivx4_FillPlugins(s_plugin_props);

    return s_plugin_props;
}
extern "C" IVideoEncoder* CreateVideoEncoder(const CodecInfo& info, fourcc_t compressor, const BITMAPINFOHEADER& bh)
{
    error = "";
    IVideoEncoder* result = new DIVX_VideoEncoder(info, compressor, bh);
    if (error.size())
    {
	printf("DivX4 error: %s\n", (const char*)error);
	delete result;
	return 0;
    }

    return result;
}
extern "C" IVideoDecoder* CreateVideoDecoder(const CodecInfo& info, const BITMAPINFOHEADER& bh, int flip)
{
    error="";
    IVideoDecoder* result = new DIVX_VideoDecoder(info, bh, flip);
    if (error.size()) {delete result; return 0;}
    return result;
}
extern "C" avm::string GetError() { return error; }
extern "C" int GetPluginVersion() { return PLUGIN_API_VERSION; }

extern "C" int GetAttrInt(const CodecInfo& info, const char* attribute, int& value)
{
    if (strcmp(attribute, strPostProcessing)==0)
	value=Registry::ReadInt(strOpendivx, strPostProcessing, 0);
    else if (strcmp(attribute, strMaxAuto)==0)
	value=Registry::ReadInt(strOpendivx, strMaxAuto, 6);

    else if (strcmp(attribute, strBitRate)==0)
	value=Registry::ReadInt(strOpendivx, strBitRate, 800000);
    else if (strcmp(attribute, "rc_period")==0)
	value=Registry::ReadInt(strOpendivx, "rc_period", 200);
    else if (strcmp(attribute, "min_quantizer")==0)
	value=Registry::ReadInt(strOpendivx, "min_quantizer", 1);
    else if (strcmp(attribute, "max_quantizer")==0)
	value=Registry::ReadInt(strOpendivx, "max_quantizer", 16);
    else if (strcmp(attribute, "quality")==0)
	value=Registry::ReadInt(strOpendivx, "quality", 0);
    else if (strcmp(attribute, "bidirect")==0)
	value=Registry::ReadInt(strOpendivx, "bidirect", 0);
    else if (strcmp(attribute, strDeinterlace)==0)
	value=Registry::ReadInt(strOpendivx, strDeinterlace, 0);
    else
	return -1;
    return 0;
}

extern "C" int SetAttrInt(const CodecInfo& info, const char* attribute, int value)
{
    int retval=-1;
    if (strcmp(attribute, strPostProcessing)==0)
	retval=Registry::WriteInt(strOpendivx, strPostProcessing, value);
    else if (strcmp(attribute, strMaxAuto)==0)
	retval=Registry::WriteInt(strOpendivx, strMaxAuto, value);

    else if (strcmp(attribute, strBitRate)==0)
	retval=Registry::WriteInt(strOpendivx, strBitRate, value);
    else if (strcmp(attribute, "rc_period")==0)
	retval=Registry::WriteInt(strOpendivx, "rc_period", value);
    else if (strcmp(attribute, "min_quantizer")==0)
	retval=Registry::WriteInt(strOpendivx, "min_quantizer", value);
    else if (strcmp(attribute, "max_quantizer")==0)
	retval=Registry::WriteInt(strOpendivx, "max_quantizer", value);
    else if (strcmp(attribute, "quality")==0)
	retval=Registry::WriteInt(strOpendivx, "quality", value);
    else if (strcmp(attribute, "bidirect")==0)
	retval=Registry::WriteInt(strOpendivx, "bidirect", value);
    else if (strcmp(attribute, strDeinterlace)==0)
	retval=Registry::WriteInt(strOpendivx, strDeinterlace, value);

    return retval;
}
