#include "gsm61dec.h"
#include "xa_gsm_state.h"

MSGSM_Decoder::MSGSM_Decoder(const CodecInfo& info, const WAVEFORMATEX* wf)
    :IAudioDecoder(info, wf)
{
    GSM_Init();
}

uint_t MSGSM_Decoder::GetMinSize()
{
    return 640;
}

int MSGSM_Decoder::Convert(const void* in_data, uint_t in_size,
			   void* out_data, uint_t out_size,
			   uint_t* size_read, uint_t* size_written)
{
    unsigned num_samples=in_size/65;
    if(out_size<640*num_samples)
	num_samples=out_size/640;
    if(num_samples==0)
    {
	if(size_read)*size_read=0;
	if(size_written)*size_written=0;
	return -1;
    }	
    int ocnt=XA_ADecode_GSMM_PCMxM(num_samples*65, num_samples,
				   (char*)in_data, // no const - interface
				   (uint8_t*)out_data, out_size);
/*    if(format)
    {
	format->is_stereo=0;//mono
	format->freq=local_wf.nSamplesPerSec;//unsure
         //format->freq=44100;
	format->valid=OUT_FORMAT_VALID;
    }		*/
//    if(ocnt<out_size)
//    {
	if(size_read)*size_read=num_samples*65;
	if(size_written)*size_written=ocnt;
	return 0;
/*    }
    else
    {
	if(size_read)*size_read=(ocnt/640)*65;
	if(size_written)*size_written=ocnt-ocnt%640;
    }				*/
}
