/********************************************************

Audio decoder interface
Copyright 2000 Eugene Kuznetsov (divx@euro.ru)

*********************************************************/

#include "audiodecoder.h"
#include "gsm61dec.h"
#include "aulaw.h"
#include "pcm.h"
#include "adpcm.h"
#include "fillplugins.h"
#include "plugin.h"
#include "except.h"
#include "utils.h"

#ifdef HAVE_AC3
#include "ac3.h"
#endif
#include <stdio.h>

using namespace std;

static avm::vector<CodecInfo> audiocodecs;

extern "C" const avm::vector<CodecInfo>& RegisterPlugin()
{
    if (audiocodecs.size())
	return audiocodecs;
    libaudiodec_FillPlugins(audiocodecs);
    return audiocodecs;
}

extern "C" int GetPluginVersion() {return PLUGIN_API_VERSION;}

#define __MODULE__ "Audio decoder"
extern "C" IAudioDecoder* CreateAudioDecoder(const CodecInfo& info, const WAVEFORMATEX* format)
{
    if (!format)
	return 0;
    IAudioDecoder* decoder=0;
    char s[256];
    try
    {
	switch (info.fourcc)
	{
	case 0x01://PCM
	    decoder = new PCM_Decoder(info, format);
	    break;
	case 0x06://ALaw
	case 0x07://uLaw (just different table)
	    decoder = new AULAW_Decoder(info, format);
	    break;
	case 0x11://IMA ADPCM
	    decoder = new ADPCM_Decoder(info, format);
	    break;
	case 0x31://MS GSM 6.10
	case 0x32://MSN Audio
	    decoder = new MSGSM_Decoder(info, format);
	    break;
#ifdef HAVE_AC3
	case 0x2000://AC3
	    decoder = new AC3_Decoder(info, format);
	    break;
#endif
	default:
	    sprintf(s, "Audio format ID %d unsupported\n", format->wFormatTag);
	    throw FATAL(s);
	}
	printf("Audio in %s format\n", avm_wave_format_name(info.fourcc));
    }
    catch (FatalError& e)
    {
	e.Print();
    }
    return decoder;
}
