#ifndef MYWIDGET_H
#define MYWIDGET_H

#include <qpushbutton.h>
#include <qvariant.h>

#include <aviplay.h>
#include <Locker.h>
#include <playerwidget.h>

class ConfigDialog;
class VideoRenderer;
class QPixmap;
class QTimer;
class QLabel;
class QSlider;
class QProgressBar;
class QMessageBox;

#define Q_MenuEvent QEvent::User
#define Q_MyCloseEvent QEvent::Type(QEvent::User+2)
#define Q_MyRefreshEvent QEvent::Type(QEvent::User+3)
#define Q_MyResizeEvent QEvent::Type(QEvent::User+4)
#define Q_PosEvent QEvent::Type(QEvent::User+5)


struct AviPlayerInitParams
{
    const char* filename;
    const char* subname;
    const char* vcodec;
    const char* acodec;
    int width;
    int height;
    int quality;
    double seek;
    bool fullscreen;
    bool maximize;
    bool nogui;

    AviPlayerInitParams()
    {
        filename = subname = vcodec = acodec = 0;
	width = height = 0;
	nogui = maximize = fullscreen = false;
        seek = 0.0;
    }
};

// -----------------------------------------------------------------------------

class PixmapButton: public QPushButton
{
public:
    PixmapButton(const char* ficon, QWidget* parent);

protected:
    virtual void drawButton( QPainter* );

private:
    QPixmap m_pm;
};

// -----------------------------------------------------------------------------

class PlayerControl : public QWidget, public PlayerWidget
{
    static const int MAX_VBAR = 100;
    Q_OBJECT

public:
    static void stopfunc(int);
public:
    virtual void PW_showconf_func() {return showconf_func();}
    virtual void PW_stop_func() { return send_key_event(Qt::Key_X, 'X'); }
    virtual void PW_middle_button() {return middle_button();}
    virtual void PW_pause_func() { return send_key_event(Qt::Key_C, 'C'); }
    virtual void PW_play_func() { return send_key_event(Qt::Key_V, 'V'); }
    virtual void PW_quit_func() { return send_event(Q_MyCloseEvent); }
    virtual void PW_menu_slot() { return send_event(Q_MenuEvent); }
    virtual void PW_fullscreen() { return send_fullscreen(); }
    virtual void PW_key_func(int sym, int mod) { return key_func(sym, mod); }
    virtual void PW_resize(int w, int h) { return send_resize_event(w, h); }
    virtual void PW_refresh() { return send_event(Q_MyRefreshEvent); }
    virtual void PW_maximize_func() { return send_maximize(); }

public:
    PlayerControl(int, int);
    ~PlayerControl();
    int initPlayer(AviPlayerInitParams& avip);
    void endPlayer();
    void updatePosDisplay(int pos);
    bool isValid() { return (player) ? true : false; }
    bool isStopped() { return (player) ? player->IsStopped() : true; }
    bool isPlaying() { return (player) ? player->IsPlaying() : false; }
    bool isPaused() { return (player) ? player->IsPaused() : false; }
    //void setQuality(int q) { quality = q; }
    void ratio(int);
    void setDisplayFramePos(bool b) { m_bDisplayFramePos = b; }
    void setAutorepeat(bool b) { m_bAutorepeat = b; }
    void send_key_event(int qtkey, int qtascii = 0, int qtstate = 0);
    void send_resize_event(int x, int y);
    void send_refresh();
    void zoom(double scale);
    void zoomWH(int width, int height, int original_w, int original_h);
    double GetPos() { return (player) ? player->GetPos() : 0.; }
    double GetLengthTime();
    IAviPlayer2* GetPlayer() { return player; }
    int is_tracking;
    int _in_reseek;

public slots:
    void send_event(QEvent ev);
    void updatePos();
    void volume_func(int);
    void mute_func();
    void changed_func(int);
    void nextpage_func();
    void prevpage_func();
    void slider_func() { is_tracking = 1; }
    void reseek_func();
    void moved_func(int);
    void rcreseek(double pos);
    void pause_func();
    void open_func();
    void opensub_func();
    void openaud_func();
    void stop_func();
    void play_func();
    void showconf_func();
    void menu_func();
    void zoom_2x() { zoom(2.0); }
    void zoom_1x() { zoom(1.0); }
    void zoom_0_5x() { zoom(0.5); }
    void zoom_in();
    void zoom_out();
    void ratio_orig() { ratio(0); }
    void ratio_4_3() { ratio(1); }
    void ratio_16_9() { ratio(2); }
    void ratio_max() { ratio(4); }
    void send_fullscreen();
    void fullscreen();
    void key_func(int sym, int mod);
    void send_maximize();
    void maximize();
    void maximize_mode(int);
    void zoom_mode(int);
    void about_func();
    void middle_button();
    void Resize(int, int);
    void Refresh();

    void remote_command();
    bool event(QEvent* e);

    void help();
    void about();
    void about_movie();
    void decoder_config();
    void dropEvent(QDropEvent*);
    void dragEnterEvent(QDragEnterEvent* event);
    void starter_slot();

protected:
    void paintEvent(QPaintEvent *);
    void keyPressEvent(QKeyEvent *);
    void mouseDoubleClickEvent(QMouseEvent*);
    void readConfig();

    IAviPlayer2* player;
    //PthreadMutex mutex;
    int vollast;
    int resize_count;
    QPopupMenu* popup;
    QPopupMenu* modes;
    QPopupMenu* about_popup;
    QSlider* scroller;
    QSlider* vbar;
    QProgressBar* pbar;
    PixmapButton* b_play;
    PixmapButton* b_open;
    PixmapButton* b_pause;
    PixmapButton* b_stop;
    PixmapButton* b_about;
    PixmapButton* b_mute;
    PixmapButton* b_opensub;
    PixmapButton* b_openaud;
    QLabel* l_status;
    QLabel* l_time;
    ConfigDialog* dlg;

    QTimer* _timer;
    QTimer* _start_timer;
    int last_slider;
    avm::string m_filename;
    avm::string m_subname;
    // pick better name here
    AviPlayerInitParams apip;

    bool m_bSettingScroller;
    bool m_bKeyProcessed;
    bool m_bDisplayFramePos;
    bool m_bAutorepeat;
};

#endif // MYWIDGET_H
