/********************************************************

AVI player
Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/

#include "version.h"

#include <signal.h>
#include <unistd.h>
#include <sys/time.h>
#include <fcntl.h>
#ifdef __FreeBSD__
#include <floatingpoint.h>
#endif
#ifdef __NetBSD__
#include <ieeefp.h>
#endif

#include <iostream>
#include <stdio.h>
#include <stdlib.h> // atoi
#include <string.h>
using namespace std;

#include <qapp.h>
#include <qtextcodec.h>
#include <qtimer.h>

#include "playercontrol.h"

PlayerControl *m;
extern void killer(int);

void Usage()
{
    cout <<
	"\nUsage: aviplay [options] [<avi-file>] [<subtitle-file>]\n"
	"\n  Options:\n"
	"    --rc          Enables remote control (stdin|stdout).\n"
	"    --size <x><y> Start playing movie at dimensions x * y.\n"
	"    --fullscreen  Start playing movie in fullscreen.\n"
	"    --maximize    Start playing movie in maximized mode.\n"
	"    --seek <sec>  Seek to sec position in the movie.\n"
	"    --quality [0,1,2,3,4,auto] Start playing movie at given quality.\n"
	"\n  Keys:\n"
	"    see About in GUI and man page for more details\n"
	"\n  More options are configurable inside the GUI\n"
        << endl;
}

int main(int argc, char* argv[])
{
#if defined(__FreeBSD__) || defined(__NetBSD__)
    fpsetmask(fpgetmask() & ~(FP_X_DZ|FP_X_INV));
#endif
    double testfp = argc / 1.4;

    if (0 && (GetAvifileVersion() != AVIFILE_VERSION))
    {
	cout<<"This binary was compiled for Avifile ver. "
	    <<GetAvifileVersion()<<", but the library is ver. "
	    <<AVIFILE_VERSION<<". Aborting. "<< endl;
	return 0;
    }

    AviPlayerInitParams apip;

    int rc=0; // remote control support over stdin/stdout
    int picw=0, pich=0;

    int use_quality = 1; // autotunning is 11 0 - 4 is quality
    bool run_fullscreen = false;

    int i = 0;
    while (++i < argc) {
	if (!strcmp(argv[i], "--help") || !strcmp(argv[i], "-h"))
	{
	    Usage();
	    return 0;
	}
	else if (!strcmp(argv[i], "--nogui") || !strcmp(argv[i], "-nogui"))
	{
	    apip.nogui = true;
	}
	else if (!strcmp(argv[i], "--size") || !strcmp(argv[i], "-size") || !strcmp(argv[i], "-s"))
	{
	    if (i + 2 >= argc)
	    {
		Usage();
		return -1;
	    }
	    apip.width = atoi(argv[++i]);
	    apip.height = atoi(argv[++i]);
	}
	else if (!strcmp(argv[i], "--rc") || !strcmp(argv[i], "-rc") || !strcmp(argv[i], "-r"))
	{
	    rc=1;
	    // non-buffered stdout
	    setvbuf (stdout, (char *)NULL, _IOLBF, 0);
	}
	else if (!strcmp(argv[i], "--fullscreen") || !strcmp(argv[i], "-f"))
	{
	    apip.fullscreen = true;
	}
	else if (!strcmp(argv[i], "--maximize") || !strcmp(argv[i], "-m"))
	{
	    apip.maximize = true;
	}
	else if (!strcmp(argv[i], "--seek") || !strcmp(argv[i], "-seek"))
	{
	    if (++i < argc)
	    {
		sscanf(argv[i], "%lf", &apip.seek);
                cout << "seeking to " << apip.seek << endl;
	    }
	}
	else if (!strcmp(argv[i], "--quality") || !strcmp(argv[i], "-q"))
	{
	    if (++i >= argc)
	    {
		Usage();
		return -1;
	    }
	    if (!strcmp(argv[i], "auto") || !strcmp(argv[i], "a"))
		apip.quality = 11;
	    else
	    {
		apip.quality = atoi(argv[i]);
		cout << "quality setting " << use_quality << " is not yet implemented..." << endl;
	    }
	}
	else if (!strcmp(argv[i], "--video-codec") || !strcmp(argv[i], "-vc"))
	{
	    if (++i >= argc)
	    {
		Usage();
		return -1;
	    }
	    cout << "Forcing video codec " << argv[i] << endl;
	    apip.vcodec = argv[i];
	}
	else if (!strcmp(argv[i], "--audio-codec") || !strcmp(argv[i], "-ac"))
	{
	    if (++i >= argc)
	    {
		Usage();
		return -1;
	    }
	    cout << "Forcing audio codec " << argv[i] << endl;
	    apip.acodec = argv[i];
	}
	else
	{
            if (apip.filename == 0)
		apip.filename = argv[i];
	    else
	    {
		if (apip.subname)
		    apip.filename = apip.subname;
		apip.subname = argv[i];
	    }
	}
    }

    QApplication a(argc, argv, !apip.nogui);
    a.setDefaultCodec( QTextCodec::codecForLocale() );

    //IAviPlayer* player = CreateAviPlayer2(argc, argv);
    //cout << "fullscreen " << run_fullscreen << endl;
    //cout << "quality " << use_quality << endl;

    char* fn;
    m = new PlayerControl(384, 30);//, !apip.nogui);
    try
    {
	if (apip.filename)
	{
	    //m->setQuality(use_quality);
	    m->initPlayer(apip);
	}
	else
	    m->open_func();
    }
    catch (FatalError& error)
    {
	if (argc >= 2)
	    error.Print();
    }

    // signal(SIGINT, killer);
    m->show();
    a.setMainWidget(m);
#if 0
    QTimer t;
    if(rc)
    {
        QObject::connect(&t, SIGNAL(timeout()), m, SLOT(remote_command()));
        sleep (2);
	t.start(100);
    }
#endif
    return a.exec();
}
/*
 vim: tabstop=8
 */
