
#include <configfile.h>
#include <cstdio>

using namespace std;

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qfont.h>
#include <qfontdialog.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qspinbox.h>

#include "configdialog_impl.h"
#include "playercontrol.h"
#include "aviplay.h"

#include <stdlib.h>
#include <ostream.h>

#include <math.h> //rint
extern PlayerControl* m;
/*
 *  Constructs a ConfigDialog_impl which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ConfigDialog_impl::ConfigDialog_impl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : ConfigDialog( parent, name, modal, fl ), fontchange(false)
{
}

ConfigDialog_impl::ConfigDialog_impl()
    : ConfigDialog(0, "Configuration", true), fontchange(false)
{
    IAviPlayer* p = m->GetPlayer();

    if (!p)
    {
        cout << "No player object - can't stat values for now" << endl;
	return;
    }

    indexLast = 0;

    char* fs = 0;
    char* http_proxy = 0;
    float sub_async;
    int audio_resampling_rate;
    int rate;
    bool audio_resampling;

    bool use_yuv;
    bool use_http_proxy;
    bool autorepeat;
    bool quality_auto;
    bool preserve_aspect;
    bool display_frame_pos;
    bool video_buffered;
    bool video_direct;
    bool video_dropping;


    p->Get(p->ASYNC_TIME_MS, &m_iAsyncOriginal,
	   p->SUBTITLE_FONT, &fs,
	   p->SUBTITLE_ASYNC_TIME_MS, &sub_async,
	   p->AUDIO_STREAM, &m_iAudioStreamOriginal,
	   p->HTTP_PROXY, &http_proxy,
	   p->USE_HTTP_PROXY, &use_http_proxy,
	   p->USE_YUV, &use_yuv,
	   p->AUDIO_RESAMPLING, &audio_resampling,
	   p->AUDIO_RESAMPLING_RATE, &audio_resampling_rate,
	   p->AUDIO_PLAYING_RATE, &rate,
	   p->AUTOREPEAT, &autorepeat,
	   p->VIDEO_QUALITY_AUTO, &quality_auto,
	   p->VIDEO_PRESERVE_ASPECT, &preserve_aspect,
	   p->DISPLAY_FRAME_POS, &display_frame_pos,
	   p->VIDEO_BUFFERED, &video_buffered,
	   p->VIDEO_DIRECT, &video_direct,
	   p->VIDEO_DROPPING, &video_dropping,
	   0);

    m_pAsyncSlider->setValue(m_iAsyncOriginal / 10);
    onAsyncValChanged(0);

    if (fs)
    {
#ifdef I18N
	if (*fs=='-')	/* start with '-' xlfd style? */
		m_defFont.setRawName(fs);
	else {		/* XFT Style family-pointsize */
		avm::string family;
		int point;
		char *fsp;
		fsp = strchr(fs,'-');
		if (fsp == NULL) {
			point = 10;
			family = fs;
		}
		else {
			*fsp=NULL;
			family = fs;
			point = atoi(fsp+1);
		}
		QFont font(family.c_str(),point);
		m_defFont = font;
	}
#else
	m_defFont.setRawName(fs);
#endif
	free(fs);
    }


    avm::string fname;
    if (!m_defFont.family().isNull())
	fname = m_defFont.family().ascii();

    char str[250];
    sprintf(str, "%s, %d pt%s%s",
	    fname.size() ? fname.c_str() : "default",
	    //m_defFont.family().ascii(),
	    m_defFont.pointSize(),
	    m_defFont.bold()?", bold":"",
	    m_defFont.italic()?", italic":"");

    m_pFontType->setText(str);
    m_pPreview->setFont(m_defFont);

    if (sub_async < 0)
    {
	m_pCheckBox->setChecked(true);
	sub_async*=-1;
    }
    else
	m_pCheckBox->setChecked(false);

    m_pSubAsyncMin->setValue(int(sub_async / 60));
    sub_async -= 60 * int(sub_async / 60);
    m_pSubAsyncSec->setValue(int(sub_async));

    m_pDefAudio->setValue(m_iAudioStreamOriginal);

    if (http_proxy)
    {
	if (strlen(http_proxy) > 0)
	    m_pProxyName->setText(http_proxy);
        free(http_proxy);
    }

    if (use_http_proxy)
    {
	m_pUseProxy->setChecked(true);
	m_pProxyName->setEnabled(true);
    }

    m_pHwaccel->setChecked(use_yuv);

    char b[50];
    sprintf(b, "%d", audio_resampling_rate);
    m_pAudioResamplingRate->lineEdit()->setText(b);

    for (int i = 0; frequencyList[i]; i++)
	if (frequencyList[i] == rate)
	    m_pAudioPlayingRate->setCurrentItem(i);

    m_pAudioResampling->setChecked(audio_resampling);
    onAudioResamplingToggled();

    m_pAutorepeat->setChecked(autorepeat);
    m_pQualityAuto->setChecked(quality_auto);
    m_pPreserveAspect->setChecked(preserve_aspect);
    m_pDisplayFramePos->setChecked(display_frame_pos);
    m_pVideoBuffered->setChecked(video_buffered);
    m_pVideoDirect->setChecked(video_direct);
    m_pVideoDropping->setChecked(video_dropping);


    int i = 0;
    avm::vector<CodecInfo>::iterator it;
    int sel=0;
    m_pVideoList->clear();
    for(it = video_codecs.begin(); it != video_codecs.end(); it++)
    {
	if (it->direction & CodecInfo::Decode)
	{
	    m_pVideoList->insertItem(it->GetName());
	    //if (it->fourcc == info.compressor)
	    //    sel=i;
	    i++;
	}
    }

    i = 0;
    m_pAudioList->clear();
    for(it = audio_codecs.begin(); it != audio_codecs.end(); it++)
    {
	if (it->direction & CodecInfo::Decode)
	{
	    m_pAudioList->insertItem(it->GetName());
	    //if (it->fourcc == info.compressor)
	    //    sel=i;
	    i++;
	}
    }

    connect(m_pAsyncSlider, SIGNAL(valueChanged(int)), this, SLOT(onAsyncValChanged(int)));
    connect(m_pUseProxy, SIGNAL(clicked()), this, SLOT(onProxyToggled()));
    connect(m_pAudioResampling, SIGNAL(clicked()), this, SLOT(onAudioResamplingToggled()));
    connect(m_pFontButton, SIGNAL(clicked()), this, SLOT(onFont()));
    connect(m_pApply, SIGNAL(clicked()), this, SLOT(onApply()));
    connect(m_pOk, SIGNAL(clicked()), this, SLOT(onOk()));
    connect(m_pCancel, SIGNAL(clicked()), this, SLOT(onCancel()));

    connect(m_pDefAudio, SIGNAL(valueChanged(int)), this, SLOT(onAudioStreamChanged(int)));

    //connect(m_pVideoList, SIGNAL(selectionChanged(QListBoxItem*)), this, SLOT(onSelectionChanged(QListBoxItem*)));

    connect(m_pVideoList, SIGNAL(currentChanged(QListBoxItem*)), this, SLOT(onSelectionChanged(QListBoxItem*)));
    connect(m_pVideoList, SIGNAL(pressed(QListBoxItem*)), this, SLOT(onListPressed(QListBoxItem*)));
    connect(m_pVideoList, SIGNAL(clicked(QListBoxItem*)), this, SLOT(onListClicked(QListBoxItem*)));

    connect(m_pAudioList, SIGNAL(currentChanged(QListBoxItem*)), this, SLOT(onSelectionChanged(QListBoxItem*)));
    connect(m_pAudioList, SIGNAL(pressed(QListBoxItem*)), this, SLOT(onListPressed(QListBoxItem*)));
    connect(m_pAudioList, SIGNAL(clicked(QListBoxItem*)), this, SLOT(onListClicked(QListBoxItem*)));
    // 3.0
    //connect(m_pVideoList, SIGNAL(mouseButtonPressed(int, QListBoxItem*, const QPOint&)), this,
    //        SLOT(onMouseButtonPressed(int, QListBoxItem*, const QPOint& )));
}

/*
 *  Destroys the object and frees any allocated resources
 */
ConfigDialog_impl::~ConfigDialog_impl()
{
    // no need to delete child widgets, Qt does it all for us
}

void ConfigDialog_impl::onSelectionChanged(QListBoxItem* item)
{
    if (!inswap && pressed && indexLast && indexLast != item->listBox()->index(item))
    {
        inswap = true;
	if(indexLast<0)
	{
	    indexLast=item->listBox()->index(item);
	    inswap=false;
	    return;
	}
	QListBox* lb = item->listBox();
	avm::string t = item->text().isNull() ? "" : item->text().ascii();
        int i = lb->index(item);
	QListBoxItem* itemLast=lb->item(indexLast);
	if(!itemLast)
	{
	    inswap=false;
	    return;
	}
	avm::string tlast = itemLast->text().isNull() ? "" : itemLast->text().ascii();
        int ilast = indexLast;
	if (i >= 0 && ilast >= 0)
	{
	    // swap two items
	    cout << "swap " << t << "   " << tlast << endl;
	    cout << "idx1 " << i << "  idx2 " << ilast << endl;
	    if (ilast < i)
	    {
		lb->removeItem(i);
		lb->insertItem(t.c_str(), ilast);
	    }
	    else
	    {
		lb->removeItem(ilast);
		lb->insertItem(tlast.c_str(), i);

	    }
//	    itemLast = item;
	    indexLast = i;
	}
        inswap = false;
    }

}

void ConfigDialog_impl::onListPressed(QListBoxItem* item)
{
//    cout << "Onpres " << item->text() << endl;
    pressed = true;
    inswap = false;
    //QListBox* b = item->listBox();
    if (item && item->listBox())
	indexLast = item->listBox()->index(item);
}

void ConfigDialog_impl::onListClicked(QListBoxItem* item)
{
    //cout << "Onclic " << item->text() << endl;
    pressed = false; // no item movment
}

void ConfigDialog_impl::onMouseButtonPressed(int button, QListBoxItem* item, const QPoint& pos)
{
    cout << "Onmouse " << button << " " << item->text() << endl;
}

void ConfigDialog_impl::onProxyToggled()
{
    m_pProxyName->setEnabled(m_pUseProxy->isChecked());
}

void ConfigDialog_impl::onAudioResamplingToggled()
{
    bool s = m_pAudioResampling->isChecked();
    m_pAudioResamplingRate->setEnabled(s);
    m_pAudioPlayingRate->setEnabled(s);
}

void ConfigDialog_impl::onApply()
{
    IAviPlayer* p = m->GetPlayer();

    if (fontchange && m_defFont.rawName().ascii())
    {
	avm::string fn = m_defFont.rawName().ascii();
#ifdef I18N
	/*
	 I18N Test Code
	 QT 2.3.1 does not report XLFD Style Font Name(QT_XFT is True).

	 setting SUBTITLE FONT  Registry like "FamilyName-PointSize"
	 QT_XFT is disabled setting nomal xlfd.
	*/
	QString encoding = m_defFont.encodingName(m_defFont.charSet());
	char str[250];
	str[0]=NULL;
	if (!fn.find("-")) {	/* is xlfd? */
		p->Set(IAviPlayer::SUBTITLE_FONT, fn.c_str(), 0);
	}
	else {			/* XFT style? */
		sprintf(str,"%s-%d",m_defFont.family().ascii(),
					m_defFont.pointSize());
		p->Set(IAviPlayer::SUBTITLE_FONT, str, 0);
	}
	cout<<"Encoding "<<encoding<<" charset "<<m_defFont.charSet()<<endl;
	cout<<"Font String "<<fn.c_str()<<" or "<<str<<endl;
#else
	p->Set(IAviPlayer::SUBTITLE_FONT, fn.c_str(), 0);
#endif
    }

    avm::string vcodecs;
    for (unsigned i = 0; i < m_pVideoList->count(); i++)
    {
	if (vcodecs.size() > 0)
	    vcodecs += ",";
        vcodecs += m_pVideoList->text(i);
    }

    avm::string acodecs;
    for (unsigned i = 0; i < m_pAudioList->count(); i++)
    {
	if (acodecs.size() > 0)
	    acodecs += ",";
        acodecs += m_pAudioList->text(i);
    }

    //cerr << "V: " << vcodecs << endl;
    //cerr << "A: " << acodecs << endl;

    m_iAsyncOriginal = m_pAsyncSlider->value() * 10;
    float sub_async = m_pSubAsyncMin->value()*60 + m_pSubAsyncSec->value();
    if (m_pCheckBox->isChecked())
	sub_async *= -1;

    p->Set(p->ASYNC_TIME_MS, m_iAsyncOriginal,
	   p->SUBTITLE_ASYNC_TIME_MS, int(sub_async * 1000),
	   p->USE_YUV, m_pHwaccel->isChecked(),
	   p->DEFAULT_AUDIO_STREAM, m_pDefAudio->value(),
	   p->AUDIO_RESAMPLING, m_pAudioResampling->isChecked(),
	   p->AUDIO_RESAMPLING_RATE,
             atoi(m_pAudioResamplingRate->lineEdit()->text().ascii()),
	   p->AUDIO_PLAYING_RATE,
	     frequencyList[m_pAudioPlayingRate->currentItem()],
	   p->USE_HTTP_PROXY, m_pUseProxy->isChecked(),
	   p->HTTP_PROXY, m_pProxyName->text().ascii(),
	   p->DISPLAY_FRAME_POS, m_pDisplayFramePos->isChecked(),
	   p->AUTOREPEAT, m_pAutorepeat->isChecked(),
	   p->VIDEO_PRESERVE_ASPECT, m_pPreserveAspect->isChecked(),
	   p->VIDEO_QUALITY_AUTO, m_pQualityAuto->isChecked(),
	   p->VIDEO_BUFFERED, m_pVideoBuffered->isChecked(),
	   p->VIDEO_DIRECT, m_pVideoDirect->isChecked(),
	   p->VIDEO_DROPPING, m_pVideoDropping->isChecked(),
	   p->VIDEO_CODECS, vcodecs.c_str(),
           p->AUDIO_CODECS, acodecs.c_str(),
           0);

    m->setDisplayFramePos(m_pDisplayFramePos->isChecked());
    m->setAutorepeat(m_pAutorepeat->isChecked());

    fontchange = false;
}

void ConfigDialog_impl::onOk()
{
    onApply();
    accept();
}

void ConfigDialog_impl::onCancel()
{
    m_pAsyncSlider->setValue(m_iAsyncOriginal / 10);
    m_pDefAudio->setValue(m_iAudioStreamOriginal);
    reject();
}

void ConfigDialog_impl::onAsyncValChanged(int)
{
    float value = (float)m_pAsyncSlider->value() / 100.0;
    char text[50];
    sprintf(text, "%2.2f s", value);
//    printf("%s\n", text);
    m_pAsync->setText(text);

    IAviPlayer* p = m->GetPlayer();

    if (p)
	p->Set(p->ASYNC_TIME_MS, int(value * 1000), 0);
}

void ConfigDialog_impl::onAudioStreamChanged(int)
{
    IAviPlayer* p = m->GetPlayer();
    if (p)
	p->Set(p->AUDIO_STREAM, m_pDefAudio->value(), 0);
}

void ConfigDialog_impl::onFont()
{
    bool isOk;
    QFont font = QFontDialog::getFont(&isOk, m_defFont, this, "Select font");
    if (isOk)
    {
        m_defFont = font;
	m_pPreview->setFont(font);

        char str[250];
	avm::string fname;
	if (!m_defFont.family().isNull())
	    fname = m_defFont.family().ascii();

	sprintf(str, "%s, %d pt%s%s",
		fname.size()?fname.c_str():"default",
		//m_defFont.family().ascii(),
		m_defFont.pointSize(),
		m_defFont.bold()?", bold":"",
		m_defFont.italic()?", italic":"");
	cout<<"font "<<str<<endl;
	m_pFontType->setText(str);

        fontchange = true;
        update();
    }
}

// -----------------------------------------------------------------------------

#include "configdialog_impl.moc"
