/****************************************************************************
** Form implementation generated from reading ui file './config.ui'
**
** Created: Wed Jan 17 15:00:51 2001
**      by:  The User Interface Compiler (uic)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

using namespace std;

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
//#include <qgridlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qvariant.h>
#include <qtabwidget.h>
#include <qtooltip.h>
#include <qvalidator.h>
#include <qwhatsthis.h>

#include "configdialog.h"

#include <iostream>
#include <stdio.h>

const int ConfigDialog::frequencyList[] =
{
    48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 0
};

/*
 *  Constructs a ConfigDialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ConfigDialog::ConfigDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "ConfigDialog" );
    resize( 564, 284 );
    setCaption( tr( "Configuration" ) );
    //QFont f( font() );
    //f.setFamily( "adobe-helvetica" );
    //f.setPointSize( 10 );
    //setFont( f );

    QGridLayout* gl = new QGridLayout(this);
    gl->setMargin(5);

    QTabWidget* tabWidget = new QTabWidget(this, "TabWidget");
    // ok we don't need this now tabWidget->setTabShape(QTabWidget::Rounded);
    tabWidget->insertTab(createVideo(tabWidget),
			 tr( "&Video" ) );
    tabWidget->insertTab(createAudio(tabWidget),
			 tr( "&Audio" ) );
    tabWidget->insertTab(createMisc(tabWidget),
			 tr( "&Misc" ) );
    tabWidget->insertTab(createSync(tabWidget),
			 tr( "&Sync" ) );
    tabWidget->insertTab(createSubtitleFont(tabWidget),
			 tr( "&Font" ) );
    tabWidget->insertTab(createDecoder(tabWidget),
			 tr( "&Decoder" ) );

    gl->addMultiCellWidget(tabWidget, 0, 0, 0, 3);

    m_pOk = new QPushButton( this, "Ok" );
    m_pOk->setText( tr( "Ok" ) );
    gl->addWidget(m_pOk, 1, 1);

    m_pApply = new QPushButton( this, "Apply" );
    m_pApply->setText( tr( "Apply" ) );
    gl->addWidget(m_pApply, 1, 2);

    m_pCancel = new QPushButton( this, "Cancel" );
    m_pCancel->setText( tr( "Cancel" ) );
    gl->addWidget(m_pCancel, 1, 3);

    gl->setColStretch(0, 1);
}

/*
 *  Destroys the object and frees any allocated resources
 */
ConfigDialog::~ConfigDialog()
{
    // no need to delete child widgets, Qt does it all for us
}


QWidget* ConfigDialog::createSubtitleFont(QWidget* parent)
{
    QWidget* w = new QWidget(parent);
    QVBoxLayout* vl = new QVBoxLayout(w);
    vl->setMargin(5);
    vl->setSpacing(5);

    QGroupBox* gb = new QGroupBox( w, "GroupBox1" );
    gb->setTitle( tr( "Subtitle font" ) );
    gb->setColumnLayout(0, Qt::Vertical);
    vl->addWidget(gb);

    QGridLayout* gl = new QGridLayout(gb->layout());

    m_pFontButton = new QPushButton( gb, "m_pFontButton" );
    m_pFontButton->setText( tr( "Select font..." ) );
    gl->addWidget(m_pFontButton, 0, 0);

    m_pFontType = new QLabel( gb, "FontType" );
    m_pFontType->setText( tr( "" ) );
    m_pFontType->setAlignment( QLabel::AlignCenter );
    gl->addWidget(m_pFontType, 0, 1);

    gl->setColStretch(2, 1);

    m_pPreview = new QLabel( gb, "Preview" );
    m_pPreview->setText( tr( "Quick brown fox jumps over the lazy dog." ) );
    m_pPreview->setAlignment( QLabel::AlignCenter );
    m_pPreview->setFrameShadow( QLabel::Sunken );
    m_pPreview->setFrameShape( QLabel::Panel );
    gl->addMultiCellWidget(m_pPreview, 1, 1, 0, 2);

    return w;
}


class DefAudioGroupBox: public QGroupBox
{
public:
    DefAudioGroupBox(ConfigDialog& m, QWidget* parent, const char* name) : QGroupBox(parent, name)
    {
	setTitle( tr( "Default audio stream" ) );
	setColumnLayout(0, Qt::Vertical);

	QHBoxLayout* hl = new QHBoxLayout(this->layout());
	QLabel* l1 = new QLabel( this, "TextLabel1" );
	l1->setText( tr( "Default played audio stream is # " ) );
	hl->addWidget(l1);

	m.m_pDefAudio = new QSpinBox( this, "m_pDefAudio" );
	m.m_pDefAudio->setMaxValue( 999 );
	hl->addWidget(m.m_pDefAudio);
    }
};

class HttpGroupBox: public QGroupBox
{
public:
    HttpGroupBox(ConfigDialog& m, QWidget* parent, const char* name) : QGroupBox(parent, name)
    {
	setTitle( tr( "HTTP proxy" ) );
	setColumnLayout(0, Qt::Vertical);

	QHBoxLayout* httpb = new QHBoxLayout( this->layout() );

	httpb->setMargin(15);

	m.m_pUseProxy = new QCheckBox( this, "UseProxy" );
	m.m_pUseProxy->setText( tr( "Use proxy" ) );
	QFont UseProxy_font(  m.m_pUseProxy->font() );
	m.m_pUseProxy->setFont( UseProxy_font );
	httpb->addWidget( m.m_pUseProxy );

	m.m_pProxyName = new QLineEdit( this, "ProxyName" );
	//m_pProxyName->setMinimumSize( m_pProxyName->minimumSizeHint() );
	//QFontInfo finfo( f );
	//ProxyName->setFixedHeight ( 2 * finfo.pointSize() );

	m.m_pProxyName->setEnabled( FALSE );
	//ProxyName->setEnabled( TRUE );
	httpb->addWidget( m.m_pProxyName );

    }
};

class RenderingModeGroupBox: public QGroupBox
{
public:
    RenderingModeGroupBox(ConfigDialog& m, QWidget* parent, const char* name) : QGroupBox(parent, name)
    {
	//setTitle( tr( "Rendering mode" ) );
	setColumnLayout(0, Qt::Vertical);

	QVBoxLayout* vl = new QVBoxLayout(this->layout());

	m.m_pHwaccel = new QCheckBox( this, "hwaccel" );
	m.m_pHwaccel->setText( tr( "Use YUV overlay if available (hw accelerated or sw emulation)" ) );
	vl->addWidget(m.m_pHwaccel);

	m.m_pQualityAuto = new QCheckBox( this, "qualityauto" );
	m.m_pQualityAuto->setText( tr( "Set CPU quality automagicaly (needs buffering)" ) );
	vl->addWidget(m.m_pQualityAuto);

	m.m_pVideoDirect = new QCheckBox( this, "VideoDirect" );
	m.m_pVideoDirect->setText( tr( "Use direct rendering if possible (scaling disabled without hw accel)" ) );
	vl->addWidget(m.m_pVideoDirect);

	m.m_pVideoBuffered = new QCheckBox( this, "VideoBuffering" );
	m.m_pVideoBuffered->setText( tr( "Buffer frames ahead - smoother video, but more CPU intensive" ) );
	vl->addWidget(m.m_pVideoBuffered);

	m.m_pVideoDropping = new QCheckBox( this, "VideoDropping" );
	m.m_pVideoDropping->setText( tr( "Dropping frames" ) );
	vl->addWidget(m.m_pVideoDropping);

	m.m_pPreserveAspect = new QCheckBox( this, "preserveaspect" );
	m.m_pPreserveAspect->setText( tr( "Preserve video aspect ratio" ) );
	vl->addWidget(m.m_pPreserveAspect);
    }
};

class ResamplingGroupBox: public QGroupBox
{
public:
    ResamplingGroupBox(ConfigDialog& m, QWidget* parent, const char* name) : QGroupBox(parent, name)
    {
	setTitle( tr( "Audio resampling" ) );
	setColumnLayout(0, Qt::Vertical);

	QGridLayout* gl = new QGridLayout( this->layout() );
	gl->setSpacing(5);

	m.m_pAudioResampling = new QCheckBox( this, "AudioResampling" );
	m.m_pAudioResampling->setText( tr( "Enable sound resampling" ) );
	gl->addWidget(m.m_pAudioResampling, 1, 0);

	//m.m_pAudioResamplingRate = new QSpinBox( this, "AudioResamplingRate" );
	m.m_pAudioResamplingRate = new QComboBox( this, "AudioResamplingRate" );
	//m.m_pAudioResamplingRate->setMaxValue( 128000 );
	//m.m_pAudioResamplingRate->setMinValue( 1000 );
	m.m_pAudioResamplingRate->setEditable( true );

        // !!!!FIXME - leak - destroy later
	QValidator* qv = new QIntValidator(1000, 128000, m.m_pAudioResamplingRate);
	m.m_pAudioResamplingRate->setValidator( qv );

	gl->addWidget(m.m_pAudioResamplingRate, 2, 0);

	QLabel* l1 = new QLabel( this, "ResamplingLabel" );
	l1->setText( tr( "Resampling frequency " ) );
	gl->addWidget(l1, 2, 1);

	m.m_pAudioPlayingRate = new QComboBox( this, "AudioPlayingRate" );
	for (int i = 0; m.frequencyList[i]; i++)
	{
	    m.m_pAudioResamplingRate->insertItem(QString::number(m.frequencyList[i]), i);
	    m.m_pAudioPlayingRate->insertItem(QString::number(m.frequencyList[i]), i);
	}

	gl->addWidget(m.m_pAudioPlayingRate, 3, 0);

	l1 = new QLabel( this, "PlayingLabel" );
	l1->setText( tr( "Playing frequency " ) );
	gl->addWidget(l1, 3, 1);

	gl->setColStretch(10, 1);

/*
	m.m_pUseProxy = new QCheckBox( this, "UseProxy" );
	m.m_pUseProxy->setText( tr( "Use proxy" ) );
	QFont UseProxy_font(  m.m_pUseProxy->font() );
	m.m_pUseProxy->setFont( UseProxy_font );
	httpb->addWidget( m.m_pUseProxy );

	m.m_pProxyName = new QLineEdit( this, "ProxyName" );
	m.m_pProxyName->setEnabled( FALSE );
	httpb->addWidget( m.m_pProxyName );
*/
    }
};

class DecoderGroupBox: public QGroupBox
{
public:
    DecoderGroupBox(ConfigDialog& m, QWidget* parent, const char* name) : QGroupBox(parent, name)
    {
	//setTitle( tr( "Rendering mode" ) );
	setColumnLayout(0, Qt::Vertical);

	QHBoxLayout* vl = new QHBoxLayout(this->layout());

	m.m_pVideoList = new QListBox( this, "videolistbox" );
	m.m_pVideoList->insertItem( tr( "New Item" ) );

	vl->addWidget(m.m_pVideoList);

	m.m_pAudioList = new QListBox( this, "audiolistbox" );
	m.m_pAudioList->insertItem( tr( "New Item" ) );

        vl->addWidget(m.m_pAudioList);
    }
};

QWidget* ConfigDialog::createMisc(QWidget* parent)
{
    QWidget* w = new QWidget( parent, "widget_3" );

    QGridLayout* gl = new QGridLayout(w);
    gl->setMargin(5);
    gl->setSpacing(5);

    QGroupBox* gb2 = new HttpGroupBox( *this, w, "gb2" );
    gl->addWidget(gb2, 0, 0);

    // Miscellaneous
    QGroupBox* gb3 = new QGroupBox( w, "GroupBox4_2" );
    gb3->setTitle( tr( "Miscellaneous" ) );
    gb3->setColumnLayout(0, Qt::Vertical);

    //gl->addMultiCellWidget(gb3, 0, 2, 1, 1);

    QVBoxLayout* vl = new QVBoxLayout( gb3->layout() );
    vl->setMargin(5);

    m_pAutorepeat = new QCheckBox( gb3, "autorepeat" );
    m_pAutorepeat->setText( tr( "Autoreplay - restart video when finished" ) );
    //m_pAutorepeat->setEnabled( FALSE );

    vl->addWidget(m_pAutorepeat);

    m_pDisplayFramePos = new QCheckBox( gb3, "displayfp" );
    m_pDisplayFramePos->setText( tr( "Display frame position" ) );

    vl->addWidget(m_pDisplayFramePos);

    gl->addWidget(gb3, 1, 0);

    gl->setColStretch(10, 1);
    gl->setRowStretch(10, 1);

    return w;
}

QWidget* ConfigDialog::createAudio(QWidget* parent)
{
    QWidget* w = new QWidget(parent);

    QGridLayout* gl = new QGridLayout(w);
    gl->setMargin(5);
    gl->setSpacing(5);

    QGroupBox* gb1 = new DefAudioGroupBox( *this, w, "defaudiogb" );
    gl->addWidget(gb1, 0, 0);

    QGroupBox* gb2 = new ResamplingGroupBox( *this, w, "resamplinggb" );
    gl->addWidget(gb2, 1, 0);

    gl->setColStretch(10, 1);
    gl->setRowStretch(10, 1);

    return w;
}

QWidget* ConfigDialog::createVideo(QWidget* parent)
{
    QWidget* w = new QWidget(parent);

    QGridLayout* gl = new QGridLayout(w);
    gl->setMargin(5);
    gl->setSpacing(5);

    QGroupBox* gb = new RenderingModeGroupBox( *this, w, "rendmodegb" );
    gl->addWidget(gb, 0, 0);

    return w;
}

QWidget* ConfigDialog::createDecoder(QWidget* parent)
{
    QWidget* w = new QWidget(parent);

    QGridLayout* gl = new QGridLayout(w);
    gl->setMargin(5);
    gl->setSpacing(5);

    QGroupBox* gb = new DecoderGroupBox( *this, w, "decodergb" );
    gl->addWidget(gb, 0, 0);

    return w;
}

QWidget* ConfigDialog::createSync(QWidget* parent)
{
    QWidget* w = new QWidget(parent);

    QGridLayout* gl = new QGridLayout(w);
    gl->setMargin(5);
    gl->setSpacing(5);

    QGroupBox* gb = new QGroupBox( w, "GroupBox4" );
    gb->setTitle( tr( "Audio/video synch adjustment" ) );
    gb->setColumnLayout(0, Qt::Vertical);

    gl->addWidget(gb, 0, 0);

    QHBoxLayout* hl1 = new QHBoxLayout(gb->layout());

    m_pAsyncSlider = new QSlider( gb, "AsyncSlider" );
    m_pAsyncSlider->setOrientation( QSlider::Horizontal );
    m_pAsyncSlider->setMinValue( -1000 );
    m_pAsyncSlider->setMaxValue( 1000 );
    m_pAsyncSlider->setTickmarks( QSlider::Right );
    m_pAsyncSlider->setTickInterval( 60 );
    hl1->addWidget(m_pAsyncSlider);
    hl1->setStretchFactor(m_pAsyncSlider, 85);

    m_pAsync = new QLabel( gb, "Async" );
    m_pAsync->setText( tr( "" ) );
    m_pAsync->setAlignment( QLabel::AlignCenter );
    hl1->addWidget(m_pAsync);
    hl1->setStretchFactor(m_pAsync, 15);

    m_pgSubtitleMatch = new QGroupBox( w, "m_pgSubtitleMatch" );
    m_pgSubtitleMatch->setTitle( tr( "Subtitle synch adjustment" ) );
    m_pgSubtitleMatch->setColumnLayout(0, Qt::Vertical);

    gl->addWidget(m_pgSubtitleMatch, 1, 0);

    QHBoxLayout* hl2 = new QHBoxLayout(m_pgSubtitleMatch->layout());
    hl2->setSpacing(5);

    m_pCheckBox = new QCheckBox( m_pgSubtitleMatch, "CheckBox_negative" );
    m_pCheckBox->setText( tr( "Negative" ) );
    //QFont CheckBox1_font( CheckBox1->font() );
    //CheckBox1->setFont( CheckBox1_font );
    hl2->addWidget(m_pCheckBox);

    m_pSubAsyncMin = new QSpinBox( m_pgSubtitleMatch, "m_pSubAsyncMin" );
    m_pSubAsyncMin->setMaxValue( 999 );
    hl2->addWidget(m_pSubAsyncMin);

    QLabel* l1 = new QLabel( m_pgSubtitleMatch, "TextLabel_minutes" );
    l1->setText( tr( "minutes" ) );
    l1->setAlignment( QLabel::AlignCenter );
    hl2->addWidget(l1);

    m_pSubAsyncSec = new QSpinBox( m_pgSubtitleMatch, "m_pSubAsyncSec" );
    m_pSubAsyncSec->setMaxValue( 59 );
    hl2->addWidget(m_pSubAsyncSec);

    QLabel* l2 = new QLabel( m_pgSubtitleMatch, "TextLabel_second" );
    l2->setText( tr( "seconds" ) );
    l2->setAlignment( QLabel::AlignCenter );
    hl2->addWidget(l2);

    gl->setRowStretch(2, 1);
    gl->setColStretch(1, 1);
    return w;
}

/*
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool ConfigDialog::event( QEvent* ev )
{
    bool ret = QDialog::event( ev );
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont CheckBox1_font(  m_pCheckBox->font() );
	m_pCheckBox->setFont( CheckBox1_font );
	QFont UseProxy_font(  m_pUseProxy->font() );
	m_pUseProxy->setFont( UseProxy_font );
    }
    return ret;
}

#include "configdialog.moc"
