#include "mmxnow_private.h"

static struct convtable
{
    int id;
    const char* text;
} id_string[] =
{
    { MMXNOW_YUY2_TO_RGB16, "yuy2_to_rgb16" },
    { MMXNOW_YUY2_TO_RGB24, "yuy2_to_rgb24" },
    { MMXNOW_YUY2_TO_RGB32, "yuy2_to_rgb32" },

    { MMXNOW_YV12_TO_RGB16, "yv12_to_rgb16" },
    { MMXNOW_YV12_TO_RGB24, "yv12_to_rgb24" },
    { MMXNOW_YV12_TO_RGB32, "yv12_to_rgb32" },

    { MMXNOW_RGB16_TO_YUY2, "rgb16_to_yuy2" },
    { MMXNOW_RGB24_TO_YUY2, "rgb24_to_yuy2" },
    { MMXNOW_RGB32_TO_YUY2, "rgb32_to_yuy2" },

    { MMXNOW_RGB16_TO_YV12, "rgb16_to_yv12" },
    { MMXNOW_RGB24_TO_YV12, "rgb24_to_yv12" },
    { MMXNOW_RGB32_TO_YV12, "rgb32_to_yv12" },

    { MMXNOW_RGB16_TO_YUV, "rgb16_to_yuv" },
    { MMXNOW_RGB24_TO_YUV, "rgb24_to_yuv" },
    { MMXNOW_RGB32_TO_YUV, "rgb32_to_yuv" },

    {0, 0}
};

const char* mmxnow_method_name(int id)
{
    struct convtable* c = id_string;
    for (; c->id; c++)
	if (c->id == id)
	    return c->text;
    return "missing in table!";
}
