#include "mmxnow_private.h"

#include <stdlib.h>
#include <stdio.h>

static int mmxnow_free_context(struct mmxnow_context_t* ctx)
{
    if (ctx->data)
    {
	free(ctx->data);
        ctx->data = 0;
    }

    return 0;
}

static char buffer[200];
char* mmxnow_flags_text(unsigned int flags)
{
    sprintf(buffer, "(%s%s%s%s)",
	    (flags & MMXNOW_MMX) ? " mmx " : "",
	    (flags & MMXNOW_3DNOW) ? " 3dnow " : "",
	    (flags & MMXNOW_SSE) ? " sse " : "",
	    (flags & MMXNOW_SSE2) ? " sse2 " : ""
            );
    return buffer;
}

mmxnow_context_t* mmxnow_create(int method, unsigned int flags)
{
    mmxnow_context_t* ctx = malloc(sizeof(mmxnow_context_t));
    memset(ctx, 0, sizeof(mmxnow_context_t));
    ctx->flags = flags;
    mmxnow_create_i386(ctx, method);
    if (ctx->method == 0)
	mmxnow_create_generic(ctx, method); /* flags not used */

    if (ctx->method == 0)
    {
        printf("Method \"%s\" (%d) not found???\n", mmxnow_method_name(method), method);
	/* method not found */
	free(ctx);
        ctx = 0;
    }
    else if (ctx->free == 0)
	ctx->free = mmxnow_free_context;

    return ctx;
}

void mmxnow_destroy(mmxnow_context_t* ctx)
{
    if (ctx)
    {
	ctx->free(ctx);
        free(ctx);
    }
}
