#!/bin/sh
#
echo "Generating build information..."

# Touch the timestamps on all the files since CVS messes them up
directory=`dirname $0`
touch $directory/configure.in

# Debian unstable allows to have several different versions of autoconf
# in the one system
use_autoconf=autoconf
use_autoheader=autoheader
# I think links are now OK
use_copy="--copy" 
test -h configure.ac || ln -sf configure.in configure.ac
# Debian will use 2.50 for configure.ac files automaticaly
#( which autoconf2.50 2>/dev/null | grep -q "^/" ) && use_autoconf=autoconf2.50
#( which autoheader2.50 2>/dev/null | grep -q "^/" ) && use_autoheader=autoheader2.50

DIE=0

($use_autoconf --version) < /dev/null > /dev/null 2>&1 || {
  echo
  echo "**Error**: You must have \`autoconf' installed ."
  DIE=1
}

(automake --version) < /dev/null > /dev/null 2>&1 || {
  echo
  echo "**Error**: You must have \`automake' installed."
  DIE=1
  NO_AUTOMAKE=yes
}

(aclocal --version) < /dev/null > /dev/null 2>&1 || {
  echo
  echo "**Error**: Missing \`aclocal'."
  DIE=1
}

(libtool --version) < /dev/null > /dev/null 2>&1 || {
  echo
  echo "**Error**: You must have \`libtool' installed."
  DIE=1
}


if [ -d /usr/local/share/aclocal ]; then
  if !(ls -ld /usr/local/share | grep /usr/share > /dev/null 2>/dev/null ); then
  if [ "`aclocal --print-ac-dir`" != "/usr/local/share/aclocal" ]; then
    ACLOCAL_FLAGS="-I /usr/local/share/aclocal $ACLOCAL_FLAGS"
    ACLOCAL_MAINDIR=`aclocal --print-ac-dir`
    for FILENAME in `ls $ACLOCAL_MAINDIR`; do
#    echo $FILENAME
    if [ -e /usr/local/share/aclocal/$FILENAME ]; then
	echo "WARNING: both $ACLOCAL_MAINDIR/$FILENAME and /usr/local/share/aclocal/$FILENAME exist; you must manually delete one of them"
    fi
    done
  fi
  else
    echo /usr/local/share is link to /usr/share
  fi
fi

# Regenerate configuration files
ok=0

rm -f aclocal.m4 configure config.guess config.log config.sub ltmain.sh libtool ltconfig missing mkinstalldirs

echo "Running libtoolize..."
libtoolize --force $use_copy >/dev/null || ok=1
echo "Running aclocal $ACLOCAL_FLAGS..."
aclocal $ACLOCAL_FLAGS || ok=1
# echo "Running autoupdate..."
# autoupdate || ok=1
echo "Running autoheader..."
$use_autoheader || ok=1
echo "Running autoconf..."
$use_autoconf || ok=1
echo "Running automake..."
automake --add-missing $use_copy --foreign || ok=1

if [ "${ok}" -eq 0 ]; then
	echo "Now you are ready to run ./configure"
    else
	echo "Problems detected. Please investigate."
        echo "Report aclocal = "
        aclocal --print-ac-dir
        echo "Please report your problem on avifile-admin@prak.org"
        echo "your log of build - together with these files:"
        echo "aclocal.m4 config.guess config.sub configure"
#        echo "If generated 'configure' script is useless try following:"
#        echo "   rm -f configure ltmain.sh config.guess condig.sub"
# 	 echo "   cvs update"
#        echo "   automake"
#        echo "   configure"
fi
