#include "audiodecoder.h"
#include "except.h"
#include "utils.h"

#include <stdio.h>

#define __MODULE__ "IAudioDecoder"

IAudioDecoder::IAudioDecoder(const CodecInfo& info, const WAVEFORMATEX* inw)
    :record(info)
{
    if (inw == 0)
	throw FATAL("Bad argument: NULL");

    in_fmt = *inw;
}

const CodecInfo& IAudioDecoder::GetCodecInfo() const
{
    return record;
}

uint_t IAudioDecoder::GetMinSize()
{
    return 2;
}

int IAudioDecoder::GetOutputFormat(WAVEFORMATEX* destfmt)
{
    if (!destfmt)
	return -1;

    // couple tricks here
    switch (in_fmt.wBitsPerSample)
    {
    case 0:
    case 2: // IMC
    case 4: // IMA_ADPCM
	in_fmt.wBitsPerSample = 16;
	break;
    }

    *destfmt = in_fmt; // copy just

    if (destfmt->nChannels == 5)
	destfmt->nChannels = 2; // AC3 5 channel

    switch (in_fmt.wFormatTag)
    {
    case 6: // A-Law  8 -> 16b
    case 7: // u-Law  8 -> 16b
        destfmt->wBitsPerSample = 16;
	break;
    case 0x2000:
	if (destfmt->nSamplesPerSec > 48000)
	    destfmt->nSamplesPerSec = 48000;
	if (in_fmt.nAvgBytesPerSec < in_fmt.nSamplesPerSec)
            in_fmt.nAvgBytesPerSec = in_fmt.nSamplesPerSec;
    }

    destfmt->wFormatTag = 1;//PCM
    destfmt->nBlockAlign = destfmt->nChannels * destfmt->wBitsPerSample / 8;
    destfmt->nAvgBytesPerSec = destfmt->nSamplesPerSec * destfmt->nBlockAlign;
    destfmt->cbSize = 0;
    char b[200];
    avm_wave_format(b, sizeof(b), &in_fmt);
    printf("src %s\n", b);
    avm_wave_format(b, sizeof(b), destfmt);
    printf("dst %s\n", b);

    return 0;
}

uint_t IAudioDecoder::GetSrcSize(uint_t dest_size)
{
    uint_t pcm = in_fmt.nSamplesPerSec * in_fmt.nChannels * in_fmt.wBitsPerSample / 8;

    if (!pcm || !in_fmt.nBlockAlign)
	return dest_size;

    uint_t frames = dest_size * in_fmt.nAvgBytesPerSec / pcm;
    if (frames < in_fmt.nBlockAlign)
	frames = in_fmt.nBlockAlign;
    return frames;
}
