#include "default.h"
#include "fourcc.h"
#include "utils.h"

const char* avm_fcc_name(fourcc_t fcc)
{
    switch (fcc)
    {
    case fccdiv3:
    case fccDIV3: return "DIV3 (divx)";
    case fccdiv4:
    case fccDIV4: return "DIV4 (divx)";
    case fccdiv5:
    case fccDIV5: return "DIV5 (divx)";
    case fccdiv6:
    case fccDIV6: return "DIV6 (divx)";
    case fccMP41: return "MP41 (divx)";
    case fccMP43: return "MP43 (divx)";

    case fccMP42:
    case fccmp42: return "MP42 (MS MPEG-4)";
    case fccmp43: return "MP43 (MS MPEG-4)";
    case fccmpg4:
    case fccMPG4: return "MPG4 (MS MPEG-4)";

    case fccWMV1:
    case fccwmv1: return "WMV1 (WinMP)";
    case fccWMV2:
    case fccwmv2: return "WMV2 (WinMP)";

    case fccIV32: return "IV32 (Indeo)";
    case fccIV41: return "IV41 (Indeo)";
    case fccIV50: return "IV50 (Indeo)";
    case fccI263: return "I263 (Indeo)";

    case fcccvid: return "CVID (Cinepak)";
    case fccVCR2: return "VCR2";
    case fccMJPG: return "MLPG";

    case fccYUV:  return "YUV";
    case fccYUY2: return "YUV2";
    case fccYV12: return "YV12";
    case fccIYUV: return "IYUV";
    case fccUYVY: return "UYVY";
    case fccYVYU: return "YVYU";

    default:	  return "unknown";
    }
}
