#include <default.h>
#include <avm_output.h>

#warning TODO: thread safety

AVM_BEGIN_NAMESPACE

void AvmOutput::vwrite(const char* format, va_list va)
{
    char s[1024];
    vsnprintf(s, sizeof(s)-1, format, va);
    m_sString+=s;
}
    
void AvmOutput::write(const char* format, ...)
{
    if(m_iDebugLevel<=m_iWriterDebugLevel)
	return;
    va_list va;
    va_start(va, format);
    vwrite(format, va);
    va_end(va);
    if((m_sString.size()>80) || (m_sString.find('\n')!=string::npos))
	flush();
}

void AvmOutput::writei(const char* mode, const char* format, ...)
{
    if(m_iDebugLevel<=m_iWriterDebugLevel)
	return;
    flush();
    string sOldMode=m_sCurrentMode;
    m_sCurrentMode=mode;
    va_list va;
    va_start(va, format);
    vwrite(format, va);
    va_end(va);
    flush();
    m_sCurrentMode=sOldMode;
}

void AvmOutput::writei(int debuglevel, const char* format, ...)
{
    if(m_iDebugLevel<=debuglevel)
	return;
    va_list va;
    va_start(va, format);
    vwrite(format, va);
    va_end(va);
    if((m_sString.size()>80) || (m_sString.find('\n')!=string::npos))
	flush();
}

void AvmOutput::writei(const char* mode, int debuglevel, const char* format, ...)
{
    if(m_iDebugLevel<=debuglevel)
	return;
    flush();
    string sOldMode=m_sCurrentMode;
    m_sCurrentMode=mode;
    va_list va;
    va_start(va, format);
    vwrite(format, va);
    va_end(va);
    flush();
    m_sCurrentMode=sOldMode;
}

void AvmOutput::flush()
{
    if(!m_sString.size())
	return;

    TextstreamInfo* pti=m_sMap.find_default(m_sCurrentMode.c_str());
    TextstreamInfo* pdti=m_sMap.find_default();

    if(pti->mask & 1) 
    {
	if(pti->handler)
	    pti->handler(m_sString.c_str(), pti->opt);
    }
    else if(pdti->mask & 1)
    {
	if(pdti->handler)
	    pdti->handler(m_sString.c_str(), pdti->opt);
    }
    
    if(pti->mask & 2)
    {
	if(pti->file)
	    fputs(m_sString.c_str(), pti->file);
    }
    else if(pdti->mask & 2)
    {
	if(pdti->file)
	    fputs(m_sString.c_str(), pdti->file);
    }

    if(pti->mask & 4)
    {
	if(pti->console)
	    puts(m_sString.c_str());
    }
    else if(pdti->mask & 4)
    {
	if(pdti->console)
	    puts(m_sString.c_str());
    }
    m_sString.erase();
}
    
AvmOutput out;

AVM_END_NAMESPACE
