#include "configfile.h"
#include <string.h>
//#include <stdio.h>

/* definition */
REGISTRY_BEGIN_NAMESPACE

static ConfigFile config;
static avm::string sConfigName = avm::string(".avirc");

template<class T> inline T mymin(T a, T b)
{
    return (a < b) ? a : b;
}

int ReadData(avm::string appname, avm::string valname, void* data, int size)
{
    config.Open(sConfigName);
    ConfigEntry* e = config.Find(appname, valname);

    if (e && e->type == ConfigEntry::Binary)
    {
	memcpy(data, e->b, mymin(size, e->length));
	return 0;
    }

    return -1;
}

int WriteInt(avm::string appname, avm::string valname, int value)
{
    config.Open(sConfigName);
    ConfigEntry* e=config.Find(appname, valname);
    if (e)
    {
	if (e->type==ConfigEntry::Binary)
	    delete e->b;
	e->type=ConfigEntry::Int;
	e->length=sizeof(int);
	e->i=value;
	config.dirty=true;
    }
    else
    {
	//printf("WRITEINT NOT FOUND %s  %s  %d\n", appname.c_str(), valname.c_str(), value);
	ConfigEntry en;
	en.appname=appname;
	en.valname=valname;
	en.length=sizeof(int);
	en.i=value;
	en.type=ConfigEntry::Int;
	config.push_back(en);
    }
    return 0;
}

int ReadInt(avm::string appname, avm::string valname, int def_value)
{
    config.Open(sConfigName);
    ConfigEntry* e=config.Find(appname, valname);
    if (e)
    {
	//printf("READINT %s  %d   \n", valname.c_str(), e->i);
	if (e->type != ConfigEntry::Int)
	    return -1;
	return e->i;
    }
    WriteInt(appname, valname, def_value);
    return def_value;
}

int WriteFloat(avm::string appname, avm::string valname, float value)
{
    config.Open(sConfigName);
    ConfigEntry* e=config.Find(appname, valname);
    if(e)
    {
	if(e->type==ConfigEntry::Binary)delete e->b;
	e->type=ConfigEntry::Float;
	e->length=sizeof(float);
	e->f=value;
	config.dirty=true;
	return 0;
    }
    ConfigEntry en;
    en.appname=appname;
    en.valname=valname;
    en.length=sizeof(float);
    en.f=value;
    en.type=ConfigEntry::Float;
    config.push_back(en);
    return 0;
}

float ReadFloat(avm::string appname, avm::string valname, float def_value)
{
    config.Open(sConfigName);
    ConfigEntry* e=config.Find(appname, valname);
    if (e)
    {
	if (e->type!=ConfigEntry::Float)
	    return -1;
	return e->f;
    }
    WriteFloat(appname, valname, def_value);
    return def_value;
}

int WriteString(avm::string appname, avm::string valname, avm::string value)
{
    config.Open(sConfigName);
    ConfigEntry* e=config.Find(appname, valname);
    if (e)
    {
	if (e->type==ConfigEntry::Binary)
	    delete e->b;
	e->type=ConfigEntry::Binary;
	e->length=value.size()+1;
	e->b = new char[value.size()+1];
	strcpy(e->b, value.c_str());
	config.dirty=true;
	return 0;
    }
    ConfigEntry en;
    en.appname=appname;
    en.valname=valname;
    en.type=ConfigEntry::Binary;
    en.length=value.size()+1;
    en.b=new char[value.size()+1];
    strcpy(en.b, value.c_str());
    config.push_back(en);
    return 0;
}

avm::string ReadString(avm::string appname, avm::string valname, avm::string def_value)
{
    config.Open(sConfigName);
    ConfigEntry* e = config.Find(appname, valname);

    if (e)
    {
	if (e->type!=ConfigEntry::Binary)
	    return "";
	return avm::string(e->b);
    }

    WriteString(appname, valname, def_value);
    return def_value;
}

REGISTRY_END_NAMESPACE
