#include "configfile.h"
#ifndef WIN32
#include <pwd.h>
#endif
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#ifndef WIN32
static avm::string ConfigPath = "";
static const char* getConfigPath()
{
    if (ConfigPath.size() == 0)
    {
	struct passwd* pwent = getpwuid(getuid());
	ConfigPath = pwent->pw_dir;
    }
    //printf("CodecPath %s\n", ConfigPath.c_str());
    //return ConfigPath.c_str();
    struct passwd* pwent = getpwuid(getuid());
    return pwent->pw_dir;
}
#endif

ConfigFile::ConfigFile() : dirty(false), opened(false)
{
}

ConfigFile::~ConfigFile()
{
    Close();
}

ConfigEntry* ConfigFile::Find(const avm::string& appname, const avm::string& valname)
{
    if (opened)
    {
	for (unsigned i = 0; i < entries.size(); i++)
	{
/*
	    printf("FIND %d:%d   %s %s       %s %s    \n",
                   i, entries.size(),
		   (const char*)appname, (const char*)valname,
		   (const char*)entries[i].appname,
		   (const char*)entries[i].valname);
*/
	    if (entries[i].appname == appname
		&& entries[i].valname == valname)
		return &entries[i];
	}
    }
    return 0;
}

void ConfigFile::Open(const avm::string& fn)
{
    if (opened)
	if (filename == fn)
	    return;
	else
	    Close();

    char* pathname;

#ifndef WIN32
    pathname=new char[strlen(getConfigPath()) + fn.size() + 20];
    strcpy(pathname, getConfigPath());
#else
    pathname=new char[256 + fn.size() + 20];
    GetWindowsDirectory(pathname, 256);
#endif
    strcat(pathname, "/");
    strcat(pathname, fn.c_str());
    FILE* f=fopen(pathname, "rb");
    delete[] pathname;

    filename = fn;
    opened = true;
    dirty = false;
    if(!f)
	return;

    char appname[256], valname[256], type[16];
    int len;

    while (!feof(f))
    {

	fscanf(f, "%s %s = %d [ %s ] ", appname, valname, &len, type);
	ConfigEntry e;
	e.appname=appname;
	e.valname=valname;
	e.length=len;

	if (strncmp(type, "Int", 16)==0)
	{
	    fscanf(f, "%X\n", &e.i);
	    e.type=ConfigEntry::Int;
	    entries.push_back(e);
	}
	else if (strncmp(type, "Float", 16)==0)
	{
	    fscanf(f, "%f\n", &e.f);
	    e.type=ConfigEntry::Float;
	    entries.push_back(e);
	}
	else if (strncmp(type, "Binary", 16)==0)
	{
	    e.b=new char[e.length+1];
	    e.b[e.length]=0;
	    fread(e.b, e.length, 1, f);
	    fscanf(f, "\n");
	    e.type=ConfigEntry::Binary;
	    entries.push_back(e);
	}
	else //junk
	    while (!feof(f))
	    {
		char c=0;
		fread(&c,1,1,f);
		if (c=='\n')
		    break;
	    }
    }
}

void ConfigFile::Close()
{
    if (!opened || !dirty)
	return;

    opened=false;
    char* pathname;
#ifndef WIN32
    pathname = new char[strlen(getConfigPath()) + filename.size() + 20];
    strcpy(pathname, getConfigPath());
#else
    pathname = new char[256 + filename.size() + 20];
    GetWindowsDirectory(pathname, 256);
#endif
    strcat(pathname, "/");
    strcat(pathname, filename.c_str());
    // FIXME - do backup copy before overwrite!  (rename)
    //printf("PATHNAME %s<>%s<\n", pathname, getConfigPath());
    FILE* f = fopen(pathname, "wb");
    delete[] pathname;
    if (!f)
	return;

    for (unsigned i=0; i<entries.size(); i++)
    {
	fprintf(f, "%s %s = %d [ ", entries[i].appname.c_str(), entries[i].valname.c_str(), entries[i].length);
	switch(entries[i].type)
	{
	case ConfigEntry::Int:
	    fprintf(f, "Int ] %X\n", entries[i].i);
	    break;
	case ConfigEntry::Float:
	    fprintf(f, "Float ] %f\n", entries[i].f);
	    break;
	case ConfigEntry::Binary:
	    fprintf(f, "Binary ] ");
	    fwrite(entries[i].b, entries[i].length, 1, f);
	    fprintf(f, "\n");
	    break;
	}
    }

    fclose(f);
}

void ConfigFile::push_back(const ConfigEntry& e)
{
    dirty = true;
    entries.push_back(e);
}
