#include "configfile.h"
#include <string.h>

ConfigEntry::ConfigEntry()
    :length(4), type(Int)
{
    b = 0;
}

ConfigEntry::~ConfigEntry()
{
    if (type == Binary)
	delete[] b;
}

ConfigEntry::ConfigEntry(const ConfigEntry & e)
    :length(4), type(Int)
{
    b = 0;
    operator=(e);
}

ConfigEntry& ConfigEntry::operator=(const ConfigEntry & e)
{
    if (type == Binary)
	delete[] b;

    appname = e.appname;
    valname = e.valname;
    length = e.length;
    type = e.type;
    if (type == Binary)
    {
	b = new char[length + 1];
	memcpy(b, e.b, length);
	b[length] = 0;
    }
    else if (type == Int)
	i = e.i;
    else if (type == Float)
	f = e.f;
    return *this;
}
