#include "except.h"

#include <stdarg.h>
#include <string.h>
#include <stdio.h> //vsnprintf

BaseError::~BaseError()
{
    delete[] module;
    delete[] description;
    delete[] severity;
}

BaseError::BaseError()
    :file(0), module(0), description(0), severity(0), line(0)
{
}

BaseError::BaseError(const char* sev, const char* mod, const char* f, int l, const char* desc)
    :file(f), line(l)
{
    module = new char[strlen(mod)+1];
    strcpy(module, mod);
    description = new char[strlen(desc)+256];
    description[0] = 0;
    severity = new char[strlen(sev)+1];
    strcpy(severity, sev);
}

BaseError::BaseError(const BaseError& f)
    :module(0), description(0), severity(0)
{
    operator=(f);
}

BaseError& BaseError::operator=(const BaseError& f)
{
    file = f.file;
    line = f.line;
    delete[] module;
    module = new char[strlen(f.module)+1];
    strcpy(module, f.module);
    delete[] severity;
    severity = new char[strlen(f.severity)+1];
    strcpy(severity, f.severity);
    delete[] description;
    description = new char[strlen(f.description)+1];
    strcpy(description, f.description);
    return *this;
}

void BaseError::Print()
{
    fprintf(stderr, "%s: %s: %s\n", module, severity, description);
}

void BaseError::PrintAll()
{
    fprintf(stderr, "%s: %s: %s", module, severity, description);
    if (file) fprintf(stderr, " at %s", file);
    if (line) fprintf(stderr, ": %d",line);
    fprintf(stderr, "\n");
}

const char* BaseError::GetModule() const
{
    return module;
}

const char* BaseError::GetDesc() const
{
    return description;
}

FatalError::FatalError(const char* mod, const char* f, int l, const char* desc,...)
    :BaseError("FATAL", mod, f, l, desc)
{
    va_list va;
    va_start(va, desc);
    vsnprintf(description, strlen(desc)+255, desc, va);
    va_end(va);
}

GenError::GenError(const char* mod, const char* f, int l, const char* desc,...)
    :BaseError("WARNING", mod, f, l, desc)
{
    va_list va;
    va_start(va, desc);
    vsnprintf(description, strlen(desc)+255, desc, va);
    va_end(va);
}
