/********************************************************

	Classes for writing AVIs
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/
#ifndef AVIFILE_AVIWRITE_H
#define AVIFILE_AVIWRITE_H

#include "videoencoder.h"
#include "avifmt.h"
#include "avifile.h"
#include "except.h"
#include "FileBuffer.h"

#include <unistd.h>
#include <stdlib.h>

#define __MODULE__ "AviWriteFile"

class Component
{
public:
    virtual ~Component(){}
};

class Registrator: public avm::vector<Component*>
{
public:
    Registrator():_destroying(false){}
    static Registrator Reg;
    bool _destroying;
    ~Registrator()
    {
	_destroying=true;
	for (avm::vector<Component*>::iterator it=begin(); it!=end(); it++)
	    delete *it;
    }
};

class AviWriteFile;

class AviWriteStream : public IAviWriteStream
{
friend class AviWriteFile;
public:
    AviWriteStream(AviWriteFile* file, int ckid,
		   enum AviStream::StreamType type,
		   const void* format, uint_t format_size,
		   fourcc_t handler, int frame_rate,
		   uint_t samplesize=0, int quality=0, int flags=0);

    ~AviWriteStream();
    virtual HRESULT AddChunk(const void* chunk, uint_t size, int flags=0);
    //
    // these two should be called before data insertion begins
    //
    //
    // for video streams, specify time in microsecs per frame in frame_rate
    // for audio streams - count of bytes per second
    //
    virtual uint_t GetLength() const { return m_header.dwLength; }
    virtual StreamType GetType() const { return m_type; }
protected:
    AviWriteFile* m_file;
    FileBuffer* m_fd;
    AVIStreamHeader m_header;
    StreamType m_type;
    char* m_format;
    uint_t m_forsize;
    int m_ckid;
    AviWriteStream(AviWriteFile* file, int ckid, enum AviStream::StreamType,
		   fourcc_t handler, int frame_rate, int flags=0);
    void SetVideoHeader(int quality, int width, int height)
    {
    	m_header.dwQuality=quality;
        m_header.rcFrame.right=width;
	m_header.rcFrame.bottom=labs(height);
    }
};

class AviAudioWriteStream : public IAviAudioWriteStream, public AviWriteStream
{
public:
    AviAudioWriteStream(AviWriteFile* file, int ckid, const CodecInfo& ci,
			WAVEFORMATEX* fmt, int bitrate, int flags=0);
    virtual ~AviAudioWriteStream();
    virtual HRESULT AddData(void* data, uint_t size);
    virtual const CodecInfo& GetCodecInfo() const { return record; }
    virtual uint_t GetLength() const;
    virtual HRESULT SetQuality(int quality);
    virtual HRESULT Start();
    virtual HRESULT Stop();
private:
    IAudioEncoder* m_pIEnc;
    WAVEFORMATEX srcfmt;
    int _status;
    int _bitrate;
    const CodecInfo& record;
};

class AviVideoWriteStream : public IAviVideoWriteStream, public AviWriteStream
{
public:
    AviVideoWriteStream(AviWriteFile* file, int ckid, const CodecInfo& ci,
			BITMAPINFOHEADER* srchdr,
			int frame_rate, int flags=0);
    ~AviVideoWriteStream();
    virtual HRESULT AddFrame(CImage* chunk, uint_t* =0, int* =0);
    virtual const CodecInfo& GetCodecInfo() const { return m_pIEnc->GetCodecInfo(); }
    virtual uint_t GetLength() const;
    virtual HRESULT SetQuality(int quality);
    virtual HRESULT SetKeyFrame(int frequency);
    virtual HRESULT Start();
    virtual HRESULT Stop();
private:
    IVideoEncoder* m_pIEnc;
    int m_vstatus;
    char* m_local_buffer;
};

//
//maintains global file info
//
class AviSegWriteFile;

class AviWriteFile: public IAviWriteFile, public Component
{
friend class AviWriteStream;
friend class AviSegWriteFile;
public:
    AviWriteFile(const char* name, int flags = 0, int mask = 00666);
    ~AviWriteFile();
//    void Create(const char* name, int flags=0, int mask=00777);
    virtual IAviVideoWriteStream* AddVideoStream(fourcc_t fourcc,
						 BITMAPINFOHEADER* srchdr,
						 int frame_rate, int flags = 0);
    virtual IAviVideoWriteStream* AddVideoStream(const CodecInfo& ci,
						 BITMAPINFOHEADER* srchdr,
						 int frame_rate, int flags = 0);
    virtual IAviAudioWriteStream* AddAudioStream(fourcc_t fourcc, WAVEFORMATEX* format,
						 int bitrate, int flags = 0);
    virtual IAviAudioWriteStream* AddAudioStream(const CodecInfo& ci, WAVEFORMATEX* format,
						 int bitrate, int flags = 0);

    virtual IAviWriteStream* AddStream(enum AviStream::StreamType type,
				       const void* format, uint_t format_size,
				       fourcc_t handler, int frame_rate,
				       uint_t samplesize = 0,
				       int quality = 0, int flags = 0);
    virtual const char* GetFileName() const { return m_filename.c_str(); }
    virtual int64_t GetFileSize() const;
    virtual HRESULT Reserve(uint_t size);
    virtual HRESULT WriteChunk(fourcc_t fourcc, void* data, uint_t size);
    virtual void WriteHeaders();

protected:
    FileBuffer* m_fd;
//    int m_fd;
    void _destruct();
    //
    //called when data is added to stream
    //
    void AddChunk(uint_t offset, uint_t size, uint_t id, int flags = 0);
    void write_le32(int x) { m_fd->write_le32(x); }

private:
    avm::vector<AviWriteStream*> m_streams;
    int m_strcnt;
    MainAVIHeader m_header;
    int m_status;
    avm::vector<AVIINDEXENTRY> m_index;
    avm::string m_filename;
};

#endif // AVIFILE_AVIWRITE_H
