#include "AviWrite.h"
#include "creators.h"
#include <string.h>

//#include "AviVideoWriteStream.h"

using namespace Creators;

AviVideoWriteStream::AviVideoWriteStream(AviWriteFile* file, int ckid,
					 const CodecInfo& ci,
					 BITMAPINFOHEADER* srchdr,
					 int frame_rate, int flags)
    :AviWriteStream(file, ckid, Video, ci.fourcc, frame_rate, flags ),
    m_vstatus(0), m_local_buffer(0)
{
    m_pIEnc = CreateVideoEncoder(ci, *srchdr);
    if (!m_pIEnc)
	throw FATAL("Could not create encoder");
}

AviVideoWriteStream::~AviVideoWriteStream()
{
    if (m_pIEnc)
	FreeVideoEncoder(m_pIEnc);
    if (m_local_buffer)
	delete[] m_local_buffer;
}

HRESULT AviVideoWriteStream::Start()
{
    if (m_vstatus)
	return -1;
    const BITMAPINFOHEADER& bh = m_pIEnc->GetOutputFormat();
    m_forsize = bh.biSize;
    delete m_format;
    m_format = new char[bh.biSize];
    memcpy(m_format, &bh, bh.biSize);
    m_pIEnc->Start();
    m_local_buffer = new char[m_pIEnc->GetOutputSize()];
    SetVideoHeader(m_pIEnc->GetQuality(), bh.biWidth, labs(bh.biHeight));
    m_vstatus = 1;
    return 0;
}

HRESULT AviVideoWriteStream::Stop()
{
    m_pIEnc->Stop();
    return 0;
}

HRESULT AviVideoWriteStream::AddFrame(CImage* chunk, uint_t* pSize = 0, int* pKeyframe = 0)
{
    if (m_vstatus != 1)
    {
	if(pSize)
	    *pSize = 0;
	return -1;
    }

    uint_t size = 0;
    int is_keyframe=0;
    HRESULT hr;
    if (chunk)
    {
	hr = m_pIEnc->EncodeFrame(chunk, m_local_buffer, &is_keyframe, &size);
	if (hr == 0)
	{
	    hr = AviWriteStream::AddChunk(m_local_buffer, size, is_keyframe);
	}
	else
	{
	    size = 0;
            is_keyframe = 0;
	}

    }
    else
	hr = AviWriteStream::AddChunk(NULL, 0);

    if (pSize)
	*pSize = size;
    if (pKeyframe)
	if(is_keyframe & 16)
	    *pKeyframe = 1;
	else
	    *pKeyframe = 0;
    return hr;
}

HRESULT AviVideoWriteStream::SetQuality(int quality)
{
    return m_pIEnc->SetQuality(quality);
}

HRESULT AviVideoWriteStream::SetKeyFrame(int frequency)
{
    return m_pIEnc->SetKeyFrame(frequency);
}

uint_t AviVideoWriteStream::GetLength() const
{
    return AviWriteStream::GetLength();
}
