#ifndef AVIFILE_GUIDS_H
#define AVIFILE_GUIDS_H

#include "avifmt.h"

typedef enum
{
    GUID_ERROR,
    GUID_ASF_HEADER,
    GUID_ASF_2_0_HEADER,
    GUID_DATA_HEADER,
    GUID_CODEC_COMMENT_HEADER,
    GUID_CODEC_COMMENT1_HEADER,
    GUID_STREAM_HEADER,
    GUID_FILE_HEADER,
    GUID_INDEX,

    GUID_VIDEO_STREAM,
    GUID_VIDEO_CONCEAL_NONE,
    GUID_AUDIO_STREAM,
    GUID_AUDIO_CONCEAL_NONE,
    GUID_AUDIO_CONCEAL_INTERLEAVE,

    GUID_HEAD1,
    GUID_HEAD2,

    GUID_END
} guidid_t;

guidid_t GuidGetType(const GUID& guid);
bool GuidIsType(const GUID& guid, guidid_t gid);
//
char* GuidToString(char* buffer, const GUID& guid);


#endif // AVIFILE_GUIDS_H
