#include "asffmt.h"
#include "asf_guids.h"
#include <string.h> // memcmp
#include <stdio.h> // sprintf

static const GUID guids[] =
{
    /* error */
    {0x0,},

    /* asf header */
    {0x75B22630, 0x668E, 0x11CF, {0xA6, 0xD9, 0x00, 0xAA, 0x00, 0x62, 0xCE, 0x6C}},

    /* asf 2.0 header */
    {0xD6E229D1, 0x35DA, 0x11D1, {0x90, 0x34, 0x00, 0xa0, 0xC9, 0x03, 0x49, 0xBE}},

    /* data header chunk */
    {0x75b22636, 0x668E, 0x11CF, {0xA6, 0xD9, 0x00, 0xAA, 0x00, 0x62, 0xCE, 0x6C}},

    /* codec comment header */
    {0x75b22633, 0x668e, 0x11cf, { 0xa6, 0xd9, 0x00, 0xaa, 0x00, 0x62, 0xce, 0x6c}},

    /* codec comment1 header */
    {0x86d15241, 0x311d, 0x11d0, { 0xa3, 0xa4, 0x00, 0xa0, 0xc9, 0x03, 0x48, 0xf6}},

    /* stream header */
    {0xB7DC0791, 0xA9B7, 0x11CF, {0x8E, 0xE6, 0x00, 0xC0, 0x0C, 0x20, 0x53, 0x65}},

    /* file header */
    {0x8CABDCA1, 0xA947, 0x11CF, {0x8E, 0xE4, 0x00, 0xC0, 0x0C, 0x20, 0x53, 0x65}},

    /* index */
    {0x33000890, 0xe5b1, 0x11CF, {0x89, 0xF4, 0x00, 0xA0, 0xC9, 0x03, 0x49, 0xCB}},


    /* video stream */
    {0xBC19EFC0, 0x5B4D, 0x11CF, {0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B}},

    /* video conceal none */
    {0x20FB5700, 0x5B55, 0x11CF, { 0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B}},

    /* audio stream */
    {0xF8699E40, 0x5B4D, 0x11CF, {0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B}},

    /* audio conceal none */
    {0x49f1A440, 0x4ECE, 0x11D0, {0xA3, 0xAC, 0x00, 0xA0, 0xC9, 0x03, 0x48, 0xF6}},

    /* audio conceal interleave */
    {0xBFC3CD50, 0x618F, 0x11CF, {0x8B, 0xB2, 0x00, 0xAA, 0x00, 0xB4, 0xE2, 0x20}},


    /* head1 */
    {0x5fbf03b5, 0xa92e, 0x11cf, { 0x8e, 0xe3, 0x00, 0xc0, 0x0c, 0x20, 0x53, 0x65 }},

    /* head2 */
    {0xabd3d211, 0xa9ba, 0x11cf, { 0x8e, 0xe6, 0x00, 0xc0, 0x0c, 0x20, 0x53, 0x65 }},

};
/*
char* names[]=
{
    "", "header", "data chunk", "index",
    "stream header", "ASF 2.0 header", "file header"
};
*/

bool GuidIsType(const GUID& u, guidid_t g)
{
    //cout << "GUID TEST " << u.f1 << "   " << guids[g].f1 << "  " << g << endl;
    return (memcmp(&u, &guids[g], sizeof(GUID)) == 0);
}

guidid_t GuidGetType(const GUID& u)
{
    for (unsigned i = GUID_ASF_HEADER; i < GUID_END; i++)
	if (GuidIsType(u, (guidid_t) i))
	    return (guidid_t) i;
    return GUID_ERROR;
}

char* GuidToString(char* buffer, const GUID& guid)
{
    sprintf(buffer, "%08X-%04X-%04X-%02X%02X%02X%02X%02X%02X%02X%02X",
	   guid.f1, guid.f2, guid.f3,
	   guid.f4[0], guid.f4[1], guid.f4[2], guid.f4[3],
	   guid.f4[4], guid.f4[5], guid.f4[6], guid.f4[7]);

    return buffer;
}
