#ifndef STREAMINFOPRIV_H
#define STREAMINFOPRIV_H

#include "StreamInfo.h"

struct StreamInfo::StreamInfoPriv
{
    Type m_Type;
    uint32_t m_uiFormat;	// stream format

    double m_dLengthTime;	// time in seconds for all packets
    uint_t m_uiMaxKfFrameSize;	// biggest keyframe chunk size
    uint_t m_uiMinKfFrameSize;	// smallest keyframe chunk size
    uint_t m_uiKfFrames;	// keyframe chunks
    int64_t m_uiKfFramesSize;	// total keyframe chunk size

    // should make sence probably only for video stream
    uint_t m_uiMaxFrameSize;	// biggest non-keyframe chunk size
    uint_t m_uiMinFrameSize;	// smallest non-keyframe chunk size
    uint_t m_uiFrames;		// non-keyframe chunks
    int64_t m_uiFramesSize;	// total non-keyframe chunk size
    int m_iQuality;             // quality of the stream (0..10000)
    int m_iSampleSize;		// sample size

    union
    {
	struct
	{
	    int	m_iChannels;
	    int	m_iSamplesPerSec;
	    int	m_iBitsPerSample;
            bool m_bVbr;
	} aud;
	struct
	{
	    int m_iWidth;
	    int m_iHeight;
	} vid;
    } u;

    void setKfFrames(uint_t max, uint_t min, uint_t chunks, int64_t size)
    {
	m_uiMaxKfFrameSize = max;
        m_uiMinKfFrameSize = min;
        m_uiKfFrames = chunks;
        m_uiKfFramesSize = size;
    }
    void setFrames(uint_t max, uint_t min, uint_t chunks, int64_t size)
    {
	m_uiMaxFrameSize = max;
        m_uiMinFrameSize = min;
        m_uiFrames = chunks;
        m_uiFramesSize = size;
    }
    void setVideo(int width, int height)
    {
        u.vid.m_iWidth = width;
        u.vid.m_iHeight = height;
    }
    void setAudio(int channels, int freq, int bits, bool vbr)
    {
	u.aud.m_iChannels = channels;
	u.aud.m_iSamplesPerSec = freq;
	u.aud.m_iBitsPerSample = bits;
        u.aud.m_bVbr = vbr;
    }
};

#endif
