#ifndef AVIFILE_NETWORKITERATOR_H
#define AVIFILE_NETWORKITERATOR_H

#include "Iterator.h"

class ASFNetworkInputStream;
class ASFStreamSeekInfo;

class NetworkIterator: public Iterator
{
friend class ASFNetworkInputStream;
protected:
    bool m_bValid;
    avm::vector<packet*> m_pPackets;
    unsigned m_iIndex;  // index to m_pPackets array
    avm::vector<int> m_UndoIt;
    ASFNetworkInputStream* m_pParent;
public:
    NetworkIterator(ASFNetworkInputStream* parent);
    virtual ~NetworkIterator();
    virtual const ASFStreamSeekInfo* getSeekInfo() { return 0; }
    virtual HRESULT seek(double timestamp, chunk_info* pch);
    virtual HRESULT seek(int64_t timestamp, chunk_info* pch);
    virtual packet getPacket(bool& success);
    virtual void next();
    virtual void undoPosition() { m_UndoIt.push_back(m_iIndex); }
    virtual void undo()
    {
	if (m_UndoIt.size())
	{
	    m_iIndex = m_UndoIt.back();
	    m_UndoIt.pop_back();
	}
    }
    virtual void forgetUndo();
    virtual void release();
    virtual void releaseInternal();
};

#endif
