#include "NetworkIterator.h"
#include "AsfNetworkInputStream.h"
#include <utils.h>
#include <iostream>
using namespace std;

NetworkIterator::NetworkIterator(ASFNetworkInputStream* parent)
    :m_bValid(false)
{
    m_pParent = parent;
    m_iIndex = 0;
}

NetworkIterator::~NetworkIterator()
{
}

HRESULT NetworkIterator::seek(double timestamp, chunk_info* pch)
{
    if (m_pParent->m_Ctype==Live)
	return -1;
    m_bValid=true;
    m_pParent->seekInternal(int(timestamp*1000), this);
    pch->SetKeyFrame(true);
    pch->fragment_id=0;
    pch->object_start_time=int(m_pParent->m_iTime*1000.);

    return 0;
}

HRESULT NetworkIterator::seek(int64_t timestamp, chunk_info* pch)
{
    cout<<"WARNING : NetworkIterator::seek(int64_t) is unsupported"<<endl;
    return -1;
}

packet NetworkIterator::getPacket(bool& success)
{
    Debug cout<<"NetworkIterator::getPacket()"<<endl;
    m_bValid=true;
    if(!m_pParent)
    {
	cout<<"WARNING: requested packet from illegal network iterator"<<endl;
	success=false;
	return packet();
    }

    PthreadMutex& mutex = m_pParent->m_Mutex;
//    pthread_mutex_t& condm_Mutex=m_pParent->_condm_Mutex;
    PthreadCond& cond = m_pParent->m_Cond;
//    bool& interrupt=m_pParent->_interrupt;
    mutex.Lock();

    if (!m_pParent->m_bHeadersValid)//shouldn't happen
	cond.Wait(mutex);

    if (!m_pParent->m_bHeadersValid)
    {
	mutex.Unlock();
	cout<<"WARNING: Invalid headers\n";
        success=false;
        return packet();
    }
//    pthread_mutex_unlock(mutex);

//    while(1)
//    {
//	pthread_mutex_lock(mutex);
//    if(!m_bValid)
//    {
//        cout<<"WARNING: access to invalid network iterator"<<endl;
//        pthread_mutex_unlock(mutex);
//	success=false;
//    	return packet();
//    }

    if (m_iIndex == m_pPackets.size())
    {
	cond.Wait(mutex);
	//cout << "Now CondWait DONE" << endl;
    }

    if (m_iIndex == m_pPackets.size())
    {
        cout<<"WARNING: NetworkIterator::GetPacket() interrupted"<<endl;
	mutex.Unlock();
        success=false;
        return packet();
    }

    packet* p = m_pPackets[m_iIndex];

    if(!p->size())
    {
	cout<<"WARNING: bad packet size\n";
	cout<<"Cache size: "<<m_pParent->m_Cache.size()<<endl;
	cout<<"Dumping cache:\n";
	avm::vector<packet*>::iterator it=m_pParent->m_Cache.begin();
	int cnt=0;
	for(;it!=m_pParent->m_Cache.end(); it++)
	{
	    cout<<cnt<<": "<<"size "<<(*it)->size()<<", length "<<(*it)->hdr.packet_length<<", send time "<<(*it)->hdr.send_time<<" ms\n";
	    cnt++;
	}

	mutex.Unlock();
	avm_usleep(100000);
        success=false;
        return packet();
    }
    packet answer=*p;
    mutex.Unlock();
//	    cout<<"Calling init()"<<endl;
    answer.init();
    Debug cout<<"Returning: length "<<answer.hdr.packet_length<<", send time "<<answer.hdr.send_time<<" ms\n";
    if(answer.hdr.length!=0xFF)
        success=true;
    else
        success=false;
    return answer;
}

void NetworkIterator::next()
{
    if (m_UndoIt.size() == 0)
    {
	assert(m_iIndex == 0);
	m_pPackets.pop_front();
    }
    else
        m_iIndex++;
}

void NetworkIterator::releaseInternal()
{
    m_iRefcount--;
    m_pParent = 0;
    if (!m_iRefcount)
	delete this;
}

void NetworkIterator::release()
{
    m_iRefcount--;
    if (!m_iRefcount)
    {
	if(m_pParent)m_pParent->unregister(this);
	delete this;
    }
}

void NetworkIterator::forgetUndo()
{
    m_UndoIt.pop_back();
    m_pParent->recheck();
}
