#ifndef AVIFILE_FILEITERATOR_H
#define AVIFILE_FILEITERATOR_H

#include "Iterator.h"
#include "AsfFileInputStream.h"

class FileIterator: public Iterator
{
protected:
    int64_t m_lPos;
    avm::vector<int64_t> m_Undo;
    ASFFileInputStream* m_pParent;
    int m_iId;
    ASFStreamSeekInfo* m_SeekInfo;
public:
    FileIterator(ASFFileInputStream* parent, int id);
    virtual ~FileIterator();
    virtual const ASFStreamSeekInfo* getSeekInfo() {return m_SeekInfo;}
    virtual HRESULT seek(double timestamp, chunk_info* pch);
    virtual HRESULT seek(int64_t timestamp, chunk_info* pch);
    virtual packet getPacket(bool& success);
    virtual void next() {m_lPos++;}
    virtual void undoPosition();
    virtual void undo();
    virtual void forgetUndo();
};

#endif // AVIFILE_FILEITERATOR_H
