#ifndef AVIFILE_CACHE_H
#define AVIFILE_CACHE_H

#define _LARGEFILE64_SOURCE
#ifdef AVIFILE_AVIFMT_H
#error Cache.h has to be the first inlude file you use!!!
#endif

// These classes provide basic caching abilities for files
// in AVI format. This is useful when files are played
// over NFS or SMB. Relies heavily on AVI structure.

#include "avifmt.h"
#include "except.h"
#include "Locker.h"
#include "avm_stl.h"
#include <unistd.h> // read

// Isn't this bug in NetBSD configuration - it should not have HAVE_LSEEK64
#ifdef __NetBSD__
#define lseek64 lseek
#else
#ifndef HAVE_LSEEK64
#define lseek64 lseek
#endif
#endif

//#ifdef __USE_LARGEFILE64
//#warning %%%%%%%%%%%%%%%%%%%%%% LARGEFILE64 %%%%%%%%%%%%%%%%%%%%%%
//#endif

struct req;

class Cache
{
    static const uint_t WAIT = ~0U;
    struct stream_entry
    {
	const avm::vector<AVIINDEXENTRY2>* table;
	avm::vector<req*> buffers;
	avm::vector<req*> freebuffers;

	int64_t position;       // needed chunk
	// handled internaly
	uint_t sum;             // cached bytes in stream
	int64_t offset;
	uint_t last;
        bool filling;
	//MemQueue* queue;

	stream_entry() : table(0), position(0), sum(0), offset(0), last(0) {}
	stream_entry(const avm::vector<AVIINDEXENTRY2>& _t, int64_t _pos)
	    :table(&_t), position(_pos), sum(0), offset(0), last(0) {}
    };
    uint_t m_uiSize;      // preallocated chunks for one stream
    avm::vector<stream_entry> m_streams;

    PthreadMutex mutex_in, mutex_out;
    PthreadCond cond_in, cond_out;
#if defined(__FreeBSD__) || defined(__NetBSD__)
    PthreadMutex thread_lock;
    PthreadCond thread_cond;
#endif
    PthreadTask* thread;
    req* loaded;                // currently loaded buffer
    bool m_bQuit;               // quit caching thread
    int m_iFd;                  // cached file descritor
    uint_t m_uiId;        // currently processed stream
    uint_t cache_access;  // total amount of cache access
    uint_t cache_right;   // accesses satisfied by cache
    uint_t cache_miss;    // how many times we had to wait
#ifndef QUIET
    int caller;
#endif
public:
    // FIXME: add methods for setting/getting size of cache
    Cache(uint_t size);
    ~Cache();
    int addStream(streamid_t id, const avm::vector<AVIINDEXENTRY2>& table);
    int clear();
    int create(int fd);
    int read(void* buffer, streamid_t id, framepos_t pos, uint_t size, bool& success, uint_t offset=0);
    int readDirect(void* buffer, streamid_t id, framepos_t pos, uint_t size, uint_t offset=0);
    //int read(void** buffer, streamid_t id, framepos_t pos, uint_t size, uint_t offset=0);
    int prefetch(streamid_t id, framepos_t position) {return 0;}// will be removed
    int update() {return 0;}//removes unused cache entries and requests newer ones
    double getSize();
    uint_t pickChunk();
protected:
    void dumpBuffers(const char *txt, bool show_table = false);
    void* readfunc(); // main thread for cache handling
    inline bool isCachable(stream_entry& stream, streamid_t id);  // new data could be readed
private:
    uint_t pickChunk1();	// unused - for testing
    static void* startReadfuncThread(void* arg);
};


#if 1
class InputStream
{
protected:
    static const int BFRSIZE = 256;
    int m_iFd;
    int64_t ulLength;
    Cache* cache;
    char bfr[BFRSIZE];
    uint_t m_iPos;
    uint_t m_iBuffered;
public:
    InputStream(const char*) throw(FatalError);
    ~InputStream();
    uint_t seek(int64_t offset);
    uint_t seekCur(int64_t offset);
    uint_t pos();
    uint_t len() const { return ulLength; }
    bool eof() { return (pos() >= ulLength); }

    //enter asynchronous mode
    int async();
    
    int prefetch(streamid_t id, framepos_t position);
    int addStream(streamid_t id, const avm::vector<AVIINDEXENTRY2>& table)
    {
	return (cache) ? cache->addStream(id, table) : -1;
    }

    //  int Read(uint_t offset, char* buffer, uint_t size);//asynchronous, obsolete
    int read(void* buffer, uint_t size);
    uint8_t readByte();
    uint32_t readDword();
    uint16_t readWord();
//    void* get(streamid_t id, framepos_t fpos, uint_t size, uint_t offset =0);


    //from cache:
    int read(void* buffer, streamid_t id, framepos_t fpos, uint_t size, bool& success, uint_t offset =0)
    {
	success = false;
	return (cache) ? cache->read(buffer, id, fpos, size, success, offset) : -1;
    }

    int clear()
    {
	return (cache) ? cache->clear() : -1;
    }

    double cacheSize() const
    {
	return (cache) ? cache->getSize() : 0.0;
    }
};

#else

// just to test some dumb ideas --- unused
class InputStream
{
    avm::vector<const avm::vector<AVIINDEXENTRY2>*> m_streams;
public:
    InputStream(const char*) throw(FatalError);
    ~InputStream();
    uint_t seek(int64_t offset);
    uint_t seekCur(int64_t offset);
    uint_t pos();
    uint_t len() const { return ulLength; }

    bool eof() { return (pos() >= ulLength); }

    uint8_t readByte()
    {
        uint8_t c;
	::read(m_iFd, &c, 1);

        return c;
    }

    uint32_t readDword()
    {
	uint32_t i;
	//
	i = readByte();
	i |= (readByte() << 8);
	i |= (readByte() << 16);
	i |= (readByte() << 24);

	return i;
    }

    int async() //enter asynchronous mode
    {
	//return (cache) ? cache->create(m_iFd) : -1;
        return 0;
    }
    
    int prefetch(streamid_t id, framepos_t position)
    {
	if (cache)
	{
	    cache->prefetch(id, position);
	    cache->update();
	}
	return 0;
    }
    
    int addStream(streamid_t id, const avm::vector<AVIINDEXENTRY2>& table)
    {
	m_streams.push_back(&table);
	//return (cache) ? cache->addStream(id, table) : -1;
        return 0;
    }
    //  int Read(uint_t offset, char* buffer, uint_t size);//asynchronous, obsolete
    int read(void* buffer, uint_t size);//synchronous
    //from cache:
    int read(void* buffer, streamid_t id, framepos_t _pos, uint_t size, uint_t offset =0)
    {
	lseek64(m_iFd, (*m_streams[id])[_pos].qwChunkOffset + 8 + offset, SEEK_SET);
	return ::read(m_iFd, buffer, size);
    }

    int clear()
    {
	return (cache) ? cache->clear() : -1;
    }

    double cacheSize() const
    {
	return (cache) ? cache->getSize() : 0.0;
    }

protected:
    int m_iFd;
    int64_t ulLength;
    Cache* cache;
};
#endif

#endif // AVIFILE_CACHE_H
