#ifndef AVIPLAY_AVIREADSTREAMV_H
#define AVIPLAY_AVIREADSTREAMV_H

#include "AviReadStream.h"

class IVideoDecoder;

class AviReadStreamV : public AviReadStream
{
    IVideoDecoder* videodecoder;
    int flip;
public:
    AviReadStreamV(streamid_t id, IMediaReadStream* stream);
    ~AviReadStreamV();
    virtual IVideoDecoder* GetVideoDecoder() const { return videodecoder; }
    virtual CImage* GetFrame(bool readframe = false);
    virtual uint_t GetFrameSize() const;
    virtual framepos_t GetPos() const;
    virtual uint_t GetOutputFormat(void* format = 0, uint_t size = 0) const;
    virtual double GetTime(framepos_t frame = ERR) const;
    virtual uint_t GetVideoFormat(void* format, uint_t size) const;
    virtual bool IsStreaming() const;
    virtual HRESULT ReadFrame(bool render = true);
    virtual HRESULT Seek(framepos_t pos);
    virtual HRESULT SeekTime(double pos);
    virtual framepos_t SeekToKeyFrame(framepos_t pos);
    virtual double SeekTimeToKeyFrame(double pos);
    virtual HRESULT SetDirection(bool d);
    virtual HRESULT SetOutputFormat();
    virtual HRESULT StartStreaming(const char*);
    virtual HRESULT StopStreaming();
};

#endif // AVIPLAY_AVIREADSTREAMV_H
