/*************************************************************

        AviReadStreamV ( video AVI stream ) functions

*************************************************************/

#include "AviRead.h"
#include "AviReadStreamV.h"
#include "creators.h"
#include "fourcc.h"

#include <string.h>
#include <stdio.h>

#define Debug if(0)
#define __MODULE__ "AviReadStreamV"

using namespace Creators;

AviReadStreamV::AviReadStreamV(streamid_t id, IMediaReadStream* stream)
    :AviReadStream(id, stream), videodecoder(0), flip(0)
{
}

AviReadStreamV::~AviReadStreamV()
{
    StopStreaming();
}

framepos_t AviReadStreamV::SeekToKeyFrame(framepos_t pos)
{
    Debug printf("AviReadStreamV::SeekToKeyFrame() %d\n", pos);

    framepos_t n = AviReadStream::SeekToKeyFrame(pos);
    if (!m_pIStream->IsKeyFrame(n))
	SeekToPrevKeyFrame();

    //cout << "AviReadStreamV::SeekToKeyFrame() flushing " << c << "   " << n << endl;
    if (videodecoder)
	videodecoder->FlushCache();

    return n;
}

double AviReadStreamV::SeekTimeToKeyFrame(double timepos)
{
    Debug printf("AviReadStreamV::SeekTimeToKeyFrame() %f\n", timepos);

    AviReadStream::SeekTimeToKeyFrame(timepos);
    if (!m_pIStream->IsKeyFrame())
	SeekToPrevKeyFrame();

    if (videodecoder)
	videodecoder->FlushCache();

    return m_pIStream->GetSampleTime();
}

framepos_t AviReadStreamV::GetPos() const
{
    if (videodecoder)
    {
	framepos_t pos = videodecoder->GetPos();
	//printf("AviReadStreamV::GetPos() %d   - id: %d\n", pos, m_id);
	if (pos != m_pIStream->ERR)
	    return pos;
    }
    //cout << "AviReadStreamV::StreamGetPos() " << m_pIStream->GetPos() << endl;
    return AviReadStream::GetPos();
}

double AviReadStreamV::GetTime(framepos_t framep) const
{
    if (framep == ERR && videodecoder)
    {
	double t = videodecoder->GetTime();
	//printf("GetVideoTime %f    samplet: %f\n", t, m_pIStream->GetSampleTime());
	if (t >= 0.0)
	    return t;
    }

    return m_pIStream->GetSampleTime(framep);
}

/******************************************************************

    These functions are meaningless for 'unknown type' stream

******************************************************************/

uint_t AviReadStreamV::GetVideoFormat(void* format, uint_t size) const
{
    if (format)
	memcpy(format, m_format, (size < m_format_size) ? size : m_format_size);

    return m_format_size;
}

/*
HRESULT AviReadStreamV::SkipFrame()
{
    int size;
    HRESULT hr=m_pIStream->Read(1, 0, 0, &size, 0);
    if(hr!=0)
	return -1;
    if(size<0)
	return -1;
    char* temp_buffer=new char[size];
    hr=m_pIStream->Read(1, temp_buffer, size, 0, 0);
    delete temp_buffer;
    return hr;
}
HRESULT AviReadStreamV::SkipTo(double pos)
{
    if(pos>m_pIStream->LengthTime())
	return -1;
    while(pos<m_pIStream->GetSampleTime())
	if(SkipFrame())
	    return -1;
    return 0;
}
*/

CImage* AviReadStreamV::GetFrame(bool readframe)
{
    if (videodecoder)
    {
	// we decode frame here in direct mode
        // it's not being decoded in separe thread
	if (readframe)
	{
	    // check if videodecoder has free buffer
            // (as it may have couple of frames precached
	    if (videodecoder->GetFreeBuffers() > 0)
		if (ReadFrame() < 0)
		    return 0;
	}

	return videodecoder->GetFrame();
    }
    return 0;
}

uint_t AviReadStreamV::GetFrameSize() const
{
    return (videodecoder) ? videodecoder->DestFmt().biSizeImage : 0;
}

uint_t AviReadStreamV::GetOutputFormat(void* format, uint_t size) const
{
    if (!videodecoder)
	return 0;
    if (!format)
	return sizeof(BITMAPINFOHEADER);
    if (size < sizeof(BITMAPINFOHEADER))
	return 0;

    *(BITMAPINFOHEADER*)format = videodecoder->DestFmt();

    return 0;
}

bool AviReadStreamV::IsStreaming() const
{
    return (videodecoder != NULL);
}

HRESULT AviReadStreamV::ReadFrame(bool render)
{
    if (!videodecoder || GetType() != Video)
	return -1;

    if (m_iEof)
    {
        m_iEof++;
	return -1;
    }

    if (videodecoder->GetFreeBuffers() == 0)
        return -2; // not free room

    uint_t size;
    HRESULT hr = m_pIStream->Read(1, 0, 0, &size, 0);

    if (hr != 0)
    {
	// regular Eof usually - we should check if we have reached last pos
	if (m_pIStream->GetPos() < (GetLength() - 1))
	{
	    printf("AviReadStreamV::ReadFrame  WARNING: Read() failed "
		   "(stream pos = %d, stream length = %d)\n",
		   m_pIStream->GetPos(), GetLength());
	}
	m_iEof++;
	return hr;
    }

    //cout << "*************** READFRAME1 " << m_pIStream->GetPos() << "   " << size << endl;
    if (size > 0x7fffffff)
    {
	printf("AviReadStreamV::ReadFrame  WARNING: size=%d\n", size);
	return -1;
    }

    uint_t fpos = m_pIStream->GetPos();
    double ftime = m_pIStream->GetSampleTime();
    int flags;
    GetFrameFlags(&flags);

    uint_t lBytes, lSamples;
    const void* temp_buffer = m_pIStream->ReadDirect(&lBytes, &lSamples);
    if (!temp_buffer)
    {
	if (rem_limit < size + 8)
	{
	    delete[] rem_buffer;
            rem_limit = size + 8;
	    rem_buffer = new char[rem_limit];
	}
	hr = m_pIStream->Read(1, rem_buffer, size, &lBytes, &lSamples);
	temp_buffer = rem_buffer;
    }
    else
	printf("DIRECT\n");
    //cout << " READVRAME " << hr << " lsample " << lSamples << " lbytes " << lBytes << endl;
    if (hr == 0 && lSamples == 1)
	hr = videodecoder->DecodeFrame(temp_buffer, lBytes, fpos,
				       ftime, flags, render);
    else
	printf("Skipping damaged video frame\n");

    return hr;
}

HRESULT AviReadStreamV::Seek(framepos_t pos)
{
    Debug printf("AviReadStreamV::Seek() %d\n", pos);
    HRESULT hr = AviReadStream::Seek(pos);
    m_iEof = 0;

    if (videodecoder)
	videodecoder->FlushCache();

    return hr;
}

HRESULT AviReadStreamV::SeekTime(double timepos)
{
    Debug printf("AviReadStreamV::SeekTimeTo() %f\n", timepos);
    HRESULT hr = AviReadStream::SeekTime(timepos);
    m_iEof = 0;

    if (videodecoder)
	videodecoder->FlushCache();

    return hr;
}

HRESULT AviReadStreamV::SetDirection(bool d)
{
    flip = d;
    return 0;
}

HRESULT AviReadStreamV::SetOutputFormat()
{
    if (!videodecoder)
	return -1;
    // FIXME
    printf("AviReadStreamV::SetOutputFormat: not implemented!\n");

    return -1; //not implemented
}

HRESULT AviReadStreamV::StartStreaming(const char* privname=0)
{
    if (videodecoder)
    {
	printf("AviReadStreamV already streaming!\n");
	return 0;
    }

    BITMAPINFOHEADER* bh = (BITMAPINFOHEADER*) m_format;
    videodecoder = CreateVideoDecoder(*bh, 24, flip, privname);

    if (!videodecoder)
	return -1;

    videodecoder->Start();

    return 0;
}

HRESULT AviReadStreamV::StopStreaming()
{
    if (videodecoder)
    {
	//cout << "AviReadStreamV::StopStreaming() call stop" << endl;
	videodecoder->Stop();
	FreeVideoDecoder(videodecoder);
	videodecoder = 0;
    }

    return 0;
}
