#ifndef AVIPLAY_AVIREADSTREAMA_H
#define AVIPLAY_AVIREADSTREAMA_H

#include "AviReadStream.h"

class IAudioDecoder;
class AudioInfoMp3;

class AviReadStreamA : public AviReadStream
{
    IAudioDecoder* audiodecoder;
    AudioInfoMp3* m_pAudioInfo;
public:
    AviReadStreamA(streamid_t id, IMediaReadStream* stream);
    ~AviReadStreamA();
    virtual uint_t GetAudioFormat(void* format = 0, uint_t size = 0) const;
    virtual uint_t GetFrameSize() const;
    virtual uint_t GetOutputFormat(void* format = 0, uint_t size = 0) const;
    virtual framepos_t GetPos() const;
    virtual double GetTime(framepos_t frame = ERR) const;
    virtual bool IsStreaming() const;
    virtual HRESULT SkipTo(double pos);
    virtual HRESULT ReadFrames(void* buffer, uint_t bufsize, uint_t samples,
			       uint_t& samples_read, uint_t& bytes_read);
    virtual HRESULT StartStreaming(const char*);
    virtual HRESULT StopStreaming();
};

#endif // AVIPLAY_AVIREADSTREAMA_H
