#ifndef AVIFILE_AVIREADSTREAM_H
#define AVIFILE_AVIREADSTREAM_H

#include "avifile.h"
#include "ReadHandlers.h"

class AviReadFile;

class AviReadStream : public IAviReadStream
{
    friend class AviReadFile;

protected:
    IMediaReadStream* m_pIStream;
    streamid_t m_id;
    char* m_format;
    uint_t m_format_size;
    uint_t m_ch_off;//chunk offset for streams with fixed sample size
    int m_iEof;
    char* rem_buffer;
    uint_t rem_size;
    uint_t rem_limit;
public:
    //AviReadStream-specific
    AviReadStream(streamid_t id, IMediaReadStream* stream);
    ~AviReadStream();
    virtual StreamType GetType() const;
    virtual uint_t GetHeader(void* pheader = 0, uint_t size = 0) const;
    virtual uint_t GetAudioFormat(void* format = 0, uint_t size = 0) const;
    virtual uint_t GetVideoFormat(void* format = 0, uint_t size = 0) const;
    virtual IVideoDecoder* GetVideoDecoder() const;
    //Size of stream and one frame
    virtual framepos_t GetLength() const;
    virtual double GetLengthTime() const;
    virtual HRESULT GetFrameFlags(int* flags) const;
    virtual double GetFrameTime() const;
    virtual framepos_t GetPos() const;
    virtual StreamInfo* GetStreamInfo() const;
    virtual double GetTime(framepos_t frame = ERR) const;
    //Positioning in stream
    virtual HRESULT Seek(framepos_t pos);
    virtual HRESULT SeekTime(double pos);
    virtual framepos_t SeekToKeyFrame(framepos_t pos);
    virtual double SeekTimeToKeyFrame(double pos);
    virtual HRESULT SkipFrame();
    virtual HRESULT SkipTo(double pos);

    //Reading decompressed data
    virtual HRESULT SetDirection(bool d) { return -1; }
    virtual HRESULT SetOutputFormat(void* bi, uint_t size);
    virtual HRESULT ReadFrame(bool render = true);
    virtual CImage* GetFrame(bool readframe = false);
    virtual uint_t GetFrameSize() const;

    HRESULT ReadFrames(void* buffer, uint_t bufsize, uint_t samples,
		       uint_t& samples_read, uint_t& bytes_read);
    HRESULT ReadDirect(void* buffer, uint_t bufsize, uint_t samples,
		       uint_t& samples_read, uint_t& bytes_read,
		       int* flags = 0);

    virtual framepos_t GetNextKeyFrame(framepos_t frame = ERR) const;
    virtual framepos_t GetPrevKeyFrame(framepos_t frame = ERR) const;

    virtual framepos_t SeekToNextKeyFrame();
    virtual framepos_t SeekToPrevKeyFrame();

    virtual bool Eof() const;

    virtual double CacheSize() const { return m_pIStream->CacheSize(); }
};

#endif
