#ifndef AVIFILE_AVIREAD_H
#define AVIFILE_AVIREAD_H

/********************************************************

    Classes for reading AVIs
    Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/

#include "Cache.h"
#include "AviReadStream.h"

class AviReadFile: public IAviReadFile
{
    MainAVIHeader m_header;
    IMediaReadHandler* m_pIFile;
    avm::vector<AviReadStream*> m_streams;
    int m_vcount;
    int m_acount;
    void destruct();
public:
    AviReadFile(const char* name);
    ~AviReadFile();
    uint_t StreamCount();
    uint_t VideoStreamCount();
    uint_t AudioStreamCount();
    IAviReadStream* GetStream(streamid_t stream_id, AviStream::StreamType type);
    virtual uint_t GetHeader(void* header, uint_t size) const;
    virtual bool IsOpened() const { return m_pIFile->IsOpened(); }
    virtual bool IsValid() const { return m_pIFile->IsValid(); }
    virtual bool IsRedirector() const { return m_pIFile->IsRedirector(); }
    virtual bool GetURLs(avm::vector<avm::string>& urls) const { return m_pIFile->GetURLs(urls); }
};

#endif // AVIFILE_AVIREAD_H
